/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CDiskTestsTable.h,v 1.5 1999/03/10 02:24:32 heller Exp $
____________________________________________________________________________*/

#pragma once

#if PGP_DEBUG	// [

#include <LColumnView.h>
#include <LPeriodical.h>

#include "CTestDrive.h"

typedef struct DiskTestInfo
{
	TestDriveConfiguration	config;
	CTestDrive				*testDriveObj;

} DiskTestInfo;

class CDiskTestsTable : public LColumnView, public LPeriodical
{
public:
	enum				{ class_ID = 'DTbl' };

						CDiskTestsTable();
						CDiskTestsTable(LStream *inStream);
	virtual				~CDiskTestsTable();

	Boolean				AddTest(void);
	void				DeleteAllTests(void);
	void				DeleteSelectedTests(void);
	virtual Boolean		FocusDraw(LPane *pane);
	virtual	void		SpendTime(const EventRecord &inMacEvent);

protected:

	virtual void		ClickCell(const STableCell &inCell,
								const SMouseDownEvent &inMouseDown);
	virtual void		DrawCell(const STableCell &inCell,
								const Rect &inLocalRect);
	virtual void		DrawSelf(void);
	
private:

	short				mTextHeight;
	
	void				DeleteTest(TableIndexT rowIndex);
};

#endif	// ] PGP_DEBUG