/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPassphraseDialog.cp,v 1.10 1999/03/10 02:24:46 heller Exp $
____________________________________________________________________________*/

#include "MacEvents.h"
#include "pgpMacMemory.h"
#include "MacStrings.h"

#include <LCaption.h>
#include <LCheckBox.h>

#include "PGPDisk.h"
#include "PGPDiskPreferences.h"

#include "CPassphraseDialog.h"
#include "CPassphraseEdit.h"


CPassphraseDialog::CPassphraseDialog()
{
}

CPassphraseDialog::CPassphraseDialog(LStream *inStream)
	: CPGPDiskDialog(inStream)
{
	mCapsLockMessageVisible = FALSE;
}

CPassphraseDialog::~CPassphraseDialog()
{
}

	void
CPassphraseDialog::FinishCreateSelf(void)
{
	LCheckBox	*hideTypingCheckboxObj;
	
	CPGPDiskDialog::FinishCreateSelf();
	
	mPassphraseFieldObj =
			(CPassphraseEdit *) FindPaneByID( kPassphraseEditFieldPaneID );
	pgpAssertAddrValid( mPassphraseFieldObj, VoidAlign ); 

	// Setup the passphrase field options
	mPassphraseFieldObj->SetHideTyping( TRUE );
	mPassphraseFieldObj->AddListener( this );
	
	// Initialize the hide typing checkbox
	hideTypingCheckboxObj =
			(LCheckBox *) FindPaneByID( kHideTypingCheckboxPaneID );
	pgpAssertAddrValid( hideTypingCheckboxObj, VoidAlign);

	hideTypingCheckboxObj->SetValue( 1 );
	hideTypingCheckboxObj->AddListener( this );
	
	StartIdling();
	SwitchTarget( mPassphraseFieldObj );
}

	Boolean
CPassphraseDialog::GetPassphrase(StringPtr passphrase)
{
	mPassphraseFieldObj->GetDescriptor( passphrase );

	return( TRUE );
}

	void
CPassphraseDialog::SetHideTyping(Boolean hideTyping)
{
	pgpAssertAddrValid( mPassphraseFieldObj, VoidAlign );
	
	mPassphraseFieldObj->SetHideTyping( hideTyping );
}

	void
CPassphraseDialog::ListenToMessage(MessageT inMessage, void *ioParam)
{
	switch( inMessage )
	{
		case kPassphraseEditFieldPaneID:
			PassphraseHasChanged();
			break;

		case msg_HideTyping:
		{
			Int32	controlValue;
			
			pgpAssertAddrValid( ioParam, Int32 );
			
			controlValue = *((Int32 *) ioParam);
			
			SetHideTyping( controlValue == kControlCheckBoxCheckedValue );
			break;
		}

		default:
			CPGPDiskDialog::ListenToMessage( inMessage, ioParam );
			break;
	}
}

//	Sets the prompt text at the top of the dialog.

	void
CPassphraseDialog::SetPrompt(ConstStr255Param prompt)
{
	LCaption	*captionObj;
	
	captionObj = (LCaption *) FindPaneByID( kDescriptionCaptionPaneID );
	pgpAssertAddrValid( captionObj, LCaption );
	
	if( captionObj != nil )
		captionObj->SetDescriptor( prompt );
}

	void
CPassphraseDialog::SpendTime(const EventRecord &inMacEvent)
{
	#pragma unused( inMacEvent )
	
	if( ( GetAllModifiers() & alphaLock ) != 0 )
	{
		if( ! mCapsLockMessageVisible )
		{
			FindPaneByID( kCapsLockDownCaptionPaneID )->Show();
			mCapsLockMessageVisible = TRUE;
		}
	}
	else
	{
		if( mCapsLockMessageVisible )
		{
			FindPaneByID( kCapsLockDownCaptionPaneID )->Hide();
			mCapsLockMessageVisible = FALSE;
		}
	}
}

	void
CPassphraseDialog::PassphraseHasChanged(void)
{
}
