/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CipherContext.h,v 1.3 1999/03/10 02:24:29 heller Exp $
____________________________________________________________________________*/

#pragma once


#include "PGPDiskCastCFB.h"



typedef union PassphraseSalt
	{
	UInt8	saltBytes[ 8 ];
	UInt32	saltLongs[ 8 / sizeof( UInt32 ) ];
	} PassphraseSalt;

typedef struct CipherContext
	{
	CASTCFBContext	castCFB;
	
	// random data used to salt passphrase and IVs
	PassphraseSalt	salt;
	} CipherContext;


typedef union CASTKey
	{
	UInt8	keyBytes[ 16 ];
	UInt32	keyLongs[ 16 / sizeof( UInt32 ) ];
	} CASTKey;

typedef CASTKey		EncryptedCASTKey;
