/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CInterruptLevelTestMgr.h,v 1.3 1999/03/10 02:34:16 heller Exp $
____________________________________________________________________________*/

#pragma once


class CInterruptLevelTester;

class CInterruptLevelTestMgr
	{
protected:
	enum { kMaxTesters = 4 };	// one disk reader, one disk writer, one file
								// reader, one file writer
	Boolean						mInProgress;
	
	CInterruptLevelTester *		mTesters[ kMaxTesters ];
	ushort						mNumTesters;
	
	short						mFileRefNum;
	
	void				CreateTesters( void );
	void				RunTesters( void );
	void				DeleteTesters( void );
	
	void				AddTester( CInterruptLevelTester *tester );
	
public:
						CInterruptLevelTestMgr( short fileRefNum );
	virtual				~CInterruptLevelTestMgr(  );

	virtual void		Run( void );
	virtual void		Stop( void );
};


