/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CStatusPanel.cp,v 1.23 1999/05/18 09:15:08 wprice Exp $
____________________________________________________________________________*/
#include <StandardFile.h>
#include <Appearance.h>

#include <LPushButton.h>
#include <LBevelButton.h>
#include <OpenTptInternet.h>

#include "CString.h"
#include "CStatusPanel.h"
#include "CPGPnet.h"
#include "pgpMem.h"
#include "MacStrings.h"
#include "PGPnetIPC.h"
#include "pgpUtilities.h"
#include "PGPnetModuleMessages.h"

namespace
{
	const PaneIDT	button_Remove			=	1001;
	const PaneIDT	button_Destination		=	1002;
	const PaneIDT	button_Protocol			=	1004;
	const PaneIDT	button_Encryption		=	1005;
	const PaneIDT	button_Authentication	=	1006;
	const PaneIDT	button_Expires			=	1007;
	const PaneIDT	button_Remaining		=	1011;
	const PaneIDT	table_Status			=	'tSta';

	const MessageT	msg_Remove			=	button_Remove;
	const MessageT	msg_Destination		=	button_Destination;
	const MessageT	msg_Protocol		=	button_Protocol;
	const MessageT	msg_Encryption		=	button_Encryption;
	const MessageT	msg_Authentication	=	button_Authentication;
	const MessageT	msg_Expires			=	button_Expires;
	const MessageT	msg_Remaining		=	button_Remaining;

	enum
	{
		STRx_StatusPanel			=	1001,
		kRemoveID					=	1,
		kAskRemoveID,
		kKilobyteID,
		kMegabyteID,
		kGigabyteID,

		STRx_Protocol				=	1006,
		STRx_Encryption				=	1007,
		STRx_Authentication			=	1008,
		
		kNoEncryptionStrID			=	11
	};
}

CStatusPanel::~CStatusPanel()
{
	if( IsntNull( mSAs ) )
	{
		PGPFreeData( mSAs );
		mSAs = NULL;
	}
}

	void
CStatusPanel::FinishCreateSelf()
{
	// Listen to buttons
	((LBevelButton *) FindPaneByID(button_Remove))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Destination))->AddListener(this);
	((LPushButton *) FindPaneByID(button_Protocol))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Encryption))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Authentication))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Expires))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Remaining))->AddListener(this);

	mSAs = NULL;
	mNumSAs = 0;
	mStatusTable	= ( (CStatusTable *)FindPaneByID( table_Status ) );
	mStatusTable->SetPanel( this );
	mStatusTable->AddListener( this );
	CPGPnet::GetApplication()->SetStatus( this );
	SetPanelTarget( mStatusTable );
}

	void
CStatusPanel::ListenToMessage(
	MessageT	inMessage,
	void *		ioParam)
{
	STableCell	cell;
	PGPUInt32	statIndex;
	UInt32		dataSize = sizeof(PGPUInt32);
	PGPBoolean	selected = FALSE;

	(void) ioParam;
	
	if( !( cell = mStatusTable->GetFirstSelectedCell() ).IsNullCell() )
		selected = TRUE;
	switch (inMessage)
	{
		case coltable_SelectChange:
			if( selected )
				((LPushButton *) FindPaneByID(button_Remove))->Enable();
			else
				((LPushButton *) FindPaneByID(button_Remove))->Disable();
			break;
		case msg_Destination:
		case msg_Remaining:
		case msg_Protocol:
		case msg_Encryption:
		case msg_Authentication:
		case msg_Expires:
		{
			break;
		}
		case msg_Remove:
			while( !( cell = mStatusTable->GetFirstSelectedCell() ).IsNullCell() )
			{
				mStatusTable->GetCellData( cell, &statIndex, dataSize );
				CPGPnet::PostPNEvent( kPGPnetHLEvent_RemoveSA,
					&mSAs[statIndex], sizeof( PGPikeSA ) );
				RemoveSA( statIndex );
			}
			break;
	};
}

	void
CStatusPanel::SetFull(
	PGPikeSA *		saList,
	PGPUInt32		count )
{
	if( IsntNull( mSAs ) )
	{
		PGPFreeData( mSAs );
		mSAs = NULL;
	}
	mStatusTable->RemoveAllRows( TRUE );
	
	if( IsntNull( saList ) )
	{
		PGPUInt32	statIndex;
		
		mSAs		= saList;
		mNumSAs		= count;
		
		for( statIndex = 0; statIndex < mNumSAs; statIndex++ )
		{
			mStatusTable->InsertSiblingRows( 1, LArray::index_Last, &statIndex,
							sizeof( PGPUInt32 ), FALSE, TRUE );
		}
	}
}

	void
CStatusPanel::UpdateSingle(
	PGPikeSA *		sa )
{
	PGPUInt32		statIndex;
	PGPBoolean		found = FALSE;
	PGPError		err;

	for( statIndex = 0; statIndex < mNumSAs; statIndex++ )
	{
		if( ( sa->ipAddress == mSAs[statIndex].ipAddress ) &&
			( sa->birthTime == mSAs[statIndex].birthTime ) &&
			pgpMemoryEqual( sa->transform,
					mSAs[statIndex].transform,
					sizeof( PGPikeDOIParams ) * kPGPike_MaxTransforms ) )
		{
			STableCell	cell;
			
			pgpCopyMemory( sa, &mSAs[statIndex], sizeof( PGPikeSA ) );
			found = TRUE;
			cell.col = 6;	cell.row = statIndex + 1;
			mStatusTable->RefreshCell( cell );
			break;
		}
	}
	if( !found )
	{
		err = PGPReallocData( CPGPnet::GetMemMgr(), &mSAs,
						( mNumSAs + 1 ) * sizeof( PGPikeSA ), 0 );
		if( IsntPGPError( err ) )
		{
			pgpCopyMemory( sa, &mSAs[mNumSAs], sizeof( PGPikeSA ) );
			mStatusTable->InsertSiblingRows( 1, LArray::index_Last, &mNumSAs,
							sizeof( PGPUInt32 ), FALSE, TRUE );
			mNumSAs++;
		}
	}
	PGPFreeData( sa );
}

	void
CStatusPanel::RemoveSingle(
	PGPikeSA *		sa )
{
	PGPUInt32		statIndex;
	PGPBoolean		found = FALSE;

	for( statIndex = 0; statIndex < mNumSAs; statIndex++ )
	{
		if( ( sa->ipAddress == mSAs[statIndex].ipAddress ) &&
			( sa->birthTime == mSAs[statIndex].birthTime ) &&
			pgpMemoryEqual( sa->transform,
					mSAs[statIndex].transform,
					sizeof( PGPikeDOIParams ) * kPGPike_MaxTransforms ) )
		{
			RemoveSA( statIndex );
			break;
		}
	}
	PGPFreeData( sa );
}

	void
CStatusPanel::RemoveSA(
	PGPUInt32		statIndex )
{
	STableCell		cell;
	TableIndexT		rows,
					cols;
	UInt32			dataSize = sizeof(PGPUInt32);

	pgpAssert( statIndex < mNumSAs );
	
	if( statIndex + 1 < mNumSAs )
		pgpCopyMemory( &mSAs[ statIndex + 1 ], &mSAs[ statIndex ],
						( mNumSAs - statIndex - 1 ) * sizeof( PGPikeSA ) );
	mNumSAs--;
	
	cell.row = statIndex + 1;
	cell.col = 1;
	mStatusTable->RemoveRows( 1, cell.row, TRUE );
	mStatusTable->GetWideOpenTableSize( rows, cols );
	for( ; cell.row <= rows; cell.row++ )
	{
		mStatusTable->GetCellData( cell, &statIndex, dataSize );
		statIndex --;
		mStatusTable->SetCellData( cell, &statIndex, dataSize );
	}
}

	void
CStatusTable::FinishCreateSelf()
{
	CColumnTable::FinishCreateSelf();
}

	Boolean
CStatusTable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&indentLevel,
	Str255				data,
	StyleParameter		&style )
{
	PGPUInt32			statIndex;
	TableIndexT			col;
	UInt32				dataSize = sizeof(PGPUInt32);
	PGPikeSA *			sa;
	char				cstr[128];
	Str255				pstr;
	PGPUInt16			trIndex;
	
	iconID;	indentLevel;	style;
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &statIndex, dataSize );
	pgpAssert( statIndex < mPanel->mNumSAs );
	sa = &mPanel->mSAs[statIndex];
	switch( col )
	{
		case 1:		// Destination
			if( sa->ipAddrStart && ( sa->ipAddrStart != sa->ipAddress ) )
				iconID = icon_Gateway;
			else
				iconID = icon_SecHost;
			OTInetHostToString( sa->ipAddress, cstr );
			CToPString( cstr, data );
			break;
		case 2:		// Protocol
			for( trIndex = 0; trIndex < sa->numTransforms; trIndex++ )
			{
				if( trIndex > 0 )
					AppendPString( "\p/", data );
				GetIndString( pstr, STRx_Protocol,
						sa->transform[trIndex].u.ipsec.protocol );
				AppendPString( pstr, data );
			}
			break;
		case 3:		// Encryption
			for( trIndex = 0; trIndex < sa->numTransforms; trIndex++ )
			{
				if( sa->transform[trIndex].u.ipsec.protocol ==
					kPGPike_PR_ESP )
				{
					GetIndString( pstr, STRx_Encryption,
							sa->transform[trIndex].u.ipsec.u.esp.t.cipher );
					AppendPString( pstr, data );
					break;
				}
			}
			if( data[0] == 0 )
			{
				GetIndString( data, STRx_Encryption, kNoEncryptionStrID );
			}
			break;
		case 4:		// Authentication
			for( trIndex = 0; trIndex < sa->numTransforms; trIndex++ )
			{
				if( sa->transform[trIndex].u.ipsec.protocol ==
					kPGPike_PR_ESP )
				{
					if( data[0] > 0 )
						AppendPString( "\p/", data );
					GetIndString( pstr, STRx_Authentication,
							sa->transform[trIndex].u.ipsec.u.esp.t.authAttr );
					AppendPString( pstr, data );
				}
				if( sa->transform[trIndex].u.ipsec.protocol ==
					kPGPike_PR_AH )
				{
					if( data[0] > 0 )
						AppendPString( "\p/", data );
					GetIndString( pstr, STRx_Authentication,
							sa->transform[trIndex].u.ipsec.u.ah.t.authAttr );
					AppendPString( pstr, data );
				}
			}
			break;
		case 5:		// Expires
		{
			PGPUInt32	deathTime = sa->birthTime + sa->secLifeTime;
			
			deathTime = PGPTimeToMacTime( deathTime );
			IUDateString( deathTime, shortDate, data );
			AppendPString( "\p ", data );
			IUTimeString( deathTime, TRUE, pstr );
			AppendPString( pstr, data );
			break;
		}
		case 6:		// Max Data
		{
			PGPUInt32				num;
			PGPUInt16				numID;
			PGPnetIKESAUserData	*	saud = (PGPnetIKESAUserData	*)sa->userData;
			
			if( saud->bytesSent < 1048576 )
			{
				num		= saud->bytesSent / 1024;
				numID	= kKilobyteID;
			}
			else if( saud->bytesSent < 1073741824 )
			{
				num		= saud->bytesSent / 1048576;
				numID	= kMegabyteID;
			}
			else
			{
				num		= saud->bytesSent / 1073741824;
				numID	= kGigabyteID;
			}
			NumToString( num, data );
			GetIndString( pstr, STRx_StatusPanel, numID );
			AppendPString( pstr, data );
			if( sa->kbLifeTime )
			{
				AppendPString( "\p/", data );
				if( sa->kbLifeTime < 1000 )
				{
					num		= sa->kbLifeTime;
					numID	= kKilobyteID;
				}
				else if( sa->kbLifeTime < 1000000 )
				{
					num		= sa->kbLifeTime / 1000;
					numID	= kMegabyteID;
				}
				else
				{
					num		= sa->kbLifeTime / 1000000;
					numID	= kGigabyteID;
				}
				NumToString( num, pstr );
				AppendPString( pstr, data );
				GetIndString( pstr, STRx_StatusPanel, numID );
				AppendPString( pstr, data );
			}
			break;
		}
	}
	return FALSE;
}

