/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CStatusPanel.h,v 1.10 1999/03/12 13:10:41 wprice Exp $
____________________________________________________________________________*/
#pragma once 

#include <LListener.h>
#include "CPanel.h"
#include "CColumnTable.h"
#include "pgpIKE.h"

class CStatusTable;

class CStatusPanel	:	public CPanel,
						public LListener
{
	friend				CStatusTable;
public:
	enum { class_ID = 'pSts' };

						CStatusPanel(LStream * inStream) : CPanel(inStream) { }
	virtual				~CStatusPanel();
					
	virtual void		ListenToMessage(MessageT inMessage, void * ioParam);
	
	void				SetFull( PGPikeSA * saList, PGPUInt32 count );
	void				UpdateSingle( PGPikeSA * sa );
	void				RemoveSingle( PGPikeSA * sa );
	void				RemoveSA( PGPUInt32		statIndex );
	void				GetSAList( PGPikeSA ** saList, PGPUInt32 *numSAs )
							{	*saList = mSAs;	*numSAs = mNumSAs;	}
						
protected:
	
	virtual void		FinishCreateSelf();

	PGPikeSA *			mSAs;
	PGPUInt32			mNumSAs;
private:
	CStatusTable *		mStatusTable;
};

class	CStatusTable	:	public CColumnTable
{
public:
	enum { class_ID = 'staT' };
						CStatusTable(LStream *inStream) : CColumnTable(inStream) { };
	virtual				~CStatusTable() { };
	void				FinishCreateSelf();
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
	void				SetPanel( CStatusPanel * panel ) { mPanel = panel;}
private:
	CStatusPanel *		mPanel;
};

