/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPnetModuleControl.cp,v 1.7 1999/03/10 02:53:39 heller Exp $
____________________________________________________________________________*/

#include <OpenTptInternet.h>
#include <modnames.h>

#include <iostream.h>

#include "PGPnetModuleControl.h"

namespace {
	const PGPUInt16	kSendExpiration = 2;
}

	OSStatus
PGPnetModuleOpenStream(
	StreamRef *	outStream)
{
	OSStatus			result;
	
	*outStream = OTStreamOpen(MI_NULS_NAME, 0, &result);
	if (result == noErr) {
		result = OTStreamIoctl(*outStream, I_PUSH, kPGPnetModuleName);
	}
	if (result == noErr) {
		PGPnetModuleStartupMsg	message;
		strioctl				controlMessage = {	I_PGPnetModuleMsg, INFTIM,
													sizeof(PGPnetModuleStartupMsg),
													reinterpret_cast<char *>(&message) };
														
		message.type = kPGPnetModuleStartupMsg;
		OTStrCopy(message.modName, kPGPnetModuleName);
		result = OTStreamIoctl(*outStream, I_STR, &controlMessage);
	}
	
	if( (result != noErr) && (*outStream != kOTInvalidStreamRef) )
	{
		OTStreamClose(*outStream);
		*outStream = kOTInvalidStreamRef;
	}
	return result;
}



	OSStatus
PGPnetModuleCloseStream(
	StreamRef	inStream)
{
	OSStatus	result;
	UInt16		message	= kPGPnetModuleShutdownMsg;
	strioctl	controlMessage = { I_PGPnetModuleMsg, INFTIM, sizeof(UInt16),
									reinterpret_cast<char *>(&message) };
	result = OTStreamIoctl(inStream, I_STR, &controlMessage);

	if (result == noErr)
		result = OTStreamClose(inStream);
	
	return result;
}



	OSStatus
PGPnetModuleSendMessage(
	StreamRef			inStream,
	PGPnetModuleMsg *	inMessage,
	PGPInt32			inMessageLength)
{
	OSStatus	result;
	strioctl	controlMessage = { I_PGPnetModuleMsg, INFTIM, inMessageLength,
									reinterpret_cast<char *>(inMessage) };
	PGPUInt32	clock = OTGetClockTimeInSecs();
	
	do {
		result = OTStreamIoctl(inStream, I_STR, &controlMessage);
	} while ((result == kEAGAINErr) && (OTGetClockTimeInSecs() < (clock + kSendExpiration)));
	if (result == kEAGAINErr) {
		result = kETIMEDOUTErr;
	}
	
	return result;
}



	OSStatus
PGPnetModuleReceiveMessage(
	StreamRef			inStream,
	PGPnetModuleMsg *	outMessage)
{
	OSStatus	result;
	OTFlags		flags = 0;
	strbuf		buffer = { sizeof(PGPnetModuleMsg), 0,
							reinterpret_cast<char *>(outMessage) };

	OTStreamSetNonBlocking(inStream);
	result = OTStreamGetMessage(inStream, NULL, &buffer, &flags);
	OTStreamSetBlocking(inStream);

	return result;
}
