 /* ======================================================================

    C header for EMSAPI version 3
    Copyright 1995, 1996 QUALCOMM Inc.
    Send comments and questions to <emsapi-info@qualcomm.com>

    Generated: Thu Dec 12 18:12:33 PST 1996
    Last updated:  April 2, 1997
    Filename: emsapi-mac.h

    USE THIS FILE TO BUILD YOUR MACINTOSH TRANSLATOR COMPONENT. 

    Note: this file is generated automatically by scripts and must be
    kept in synch with other translation API definitions, so it should
    probably not ever be changed.
*/
#ifndef EMSAPI_MAC_H_INCLUDED
#define EMSAPI_MAC_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#define SIG_EUDORA			'CSOm'

/* ========== CONSTANTS AND RETURN VALUES ================================ */

/* ----- Translator return codes --- store as a long --------------------- */ 
#define EMSR_OK              (0L)     /* The translation operation succeeded */
#define EMSR_UNKNOWN_FAIL    (1L)     /* Failed for unspecified reason */
#define EMSR_CANT_TRANS      (2L)     /* Don't know how to translate this */
#define EMSR_INVALID_TRANS   (3L)     /* The translator ID given was invalid */
#define EMSR_NO_ENTRY        (4L)     /* The value requested doesn't exist */
#define EMSR_NO_INPUT_FILE   (5L)     /* Couldn't find input file */
#define EMSR_CANT_CREATE     (6L)     /* Couldn't create the output file */
#define EMSR_TRANS_FAILED    (7L)     /* The translation failed. */
#define EMSR_INVALID         (8L)     /* Invalid argument(s) given */
#define EMSR_NOT_NOW         (9L)     /* Translation can be done not in current
                                         context */
#define EMSR_NOW            (10L)     /* Indicates translation can be performed
                                         right away */
#define EMSR_ABORTED        (11L)     /* Translation was aborted by user */
#define EMSR_DATA_UNCHANGED (12L)     /* Trans OK, data was not changed */
 
 
/* ----- Translator types --- store as a long ---------------------------- */ 
#define EMST_NO_TYPE          (-1L)
#define EMST_LANGUAGE         (0x10L)
#define EMST_TEXT_FORMAT      (0x20L)
#define EMST_GRAPHIC_FORMAT   (0x30L)
#define EMST_COMPRESSION      (0x40L)
#define EMST_COALESCED        (0x50L)
#define EMST_SIGNATURE        (0x60L)
#define EMST_PREPROCESS       (0x70L)
#define EMST_CERT_MANAGEMENT  (0x80L)


/* ----- Translator info flags and contexts --- store as a long ---------- */
/* Used both as bit flags and as constants */
#define EMSF_ON_ARRIVAL      (0x0001L) /* Call on message arrivial */
#define EMSF_ON_DISPLAY      (0x0002L) /* Call when user views message */
#define EMSF_ON_REQUEST      (0x0004L) /* Call when selected from menu */
#define EMSF_Q4_COMPLETION   (0x0008L) /* Queue and call on complete 
                                          composition of a message */
#define EMSF_Q4_TRANSMISSION (0x0010L) /* Queue and call on transmission
										  of a message */
#define EMSF_WHOLE_MESSAGE   (0x0200L) /* Works on the whole message even if
                                         it has sub-parts. (e.g. signature) */
#define EMSF_REQUIRES_MIME   (0x0400L) /* Items presented for translation
                                          should be MIME entities with
                                          canonical end of line representation,
                                          proper transfer encoding
                                          and headers */
#define EMSF_GENERATES_MIME  (0x0800L) /* Data produced will be MIME format */
#define EMSF_ALL_HEADERS     (0x1000L) /* All headers in & out of trans when
                                          MIME format is used */
#define EMSF_BASIC_HEADERS   (0x2000L) /* Just the basic to, from, subject, cc,
					  					  bcc headers */
#define EMSF_DEFAULT_Q_ON    (0x4000L) /* Causes queued translation to be on 
										  for a new message by default */
/* all other flag bits in the long are RESERVED and may not be used */


/* ----- The version of the API defined by this include file ------------- */
#define EMS_VERSION          (3)       /* Used in plugin init */
#define EMS_PB_VERSION       (3)       /* Minimum version that uses parameter blocks */
#define EMS_COMPONENT        'EuTL'    /* Macintosh component type */


/* ----- Translator and translator type specific return codes ------------ */
#define EMSC_SIGOK           (1L)      /* A signature verification succeeded */
#define EMSC_SIGBAD          (2L)      /* A signature verification failed */
#define EMSC_SIGUNKNOWN      (3L)      /* Result of verification unknown */


/* ========== DATA STRUCTURES ============================================ */
// True Mac-style declarations aren't used yet but are included in comments. 
// All strings on the Mac are PASCAL strings and all are allocated as Handles. 

/* ----- MIME Params ---------------------------- */
typedef struct emsMIMEparamS **emsMIMEparamH;
typedef struct emsMIMEparamS {
    long			size;
    Str63			name;   		/* MIME parameter name */
    Handle			value;  		/* handle size determines string length */
    emsMIMEparamH	next;  	        /* Handle for next param in list */
} emsMIMEparam, *emsMIMEParamP;
/* ----- MIME Data ----------------------------- */
typedef struct emsMIMEtype {
    long			size;
    Str63 			mimeVersion; 	/* MIME-Version: header */
    Str63			mimeType;   	/* Top-level MIME type: text,message...*/
    Str63			subType;     	/* sub-type */
    emsMIMEparamH	params;      	/* Handle to first parameter in list */
    Str63 			contentDisp;  	/* Content-Disposition */
    emsMIMEparamH 	contentParams;  /* Handle to first parameter in list */
} emsMIMEtype, *emsMIMEtypeP, **emsMIMEtypeH;
/* ----- User Address ------------------------- */
typedef struct emsAddressS **emsAddressH;
typedef struct emsAddressS {
    long			size;			/* Size of this data structure */
    StringHandle	address;		/* Optional directory for config file */
    StringHandle	realname;		/* Users full name from Eudora config */
    emsAddressH		next;			/* Linked list of addresses */
} emsAddress, *emsAddressP;
/* ----- Header Data ---------------------------- */
typedef struct emsHeaderData {
    long			size;			/* Size of this data structure */
    emsAddressH		to;				/* To Header */
    emsAddressH		from;			/* From Header */
    StringHandle	subject;		/* Subject Header */
    emsAddressH		cc;				/* cc Header */
    emsAddressH		bcc;			/* bcc Header */
    Handle			rawHeaders;		/* The 822 headers */
} emsHeaderData, *emsHeaderDataP, **emsHeaderDataH;
/* ----- How Eudora is configured ------------- */
typedef struct emsMailConfig {
    long			size;			/* Size of this data structure */
    FSSpec			configDir;		/* Optional directory for config file */
    emsAddress		userAddr;		/* Current users address */
} emsMailConfig, *emsMailConfigP, **emsMailConfigH;
/* ----- Plugin Info -------------------------- */
typedef struct emsPluginInfo {
    long			size;			/* Size of this data structure */
    long			id;				/* Place to return unique plugin id */
    long			numTrans;		/* Place to return num of translators */
    long			numAttachers;	/* Place to return num of attach hooks */
    long			numSpecials;	/* Place to return num of special hooks */
    StringHandle	desc;			/* Return for string description of plugin */
    Handle			icon;			/* Return for plugin icon data */
} emsPluginInfo, *emsPluginInfoP, **emsPluginInfoH;
/* ----- Translator Info --------------------- */
typedef struct emsTranslator {
    long			size;			/* Size of this data structure */
    long			id;				/* ID of translator to get info for */
    long			type;			/* translator type, e.g., EMST_xxx */
    unsigned long	flags;			/* translator flags */
    StringHandle	desc;			/* translator string description */
    Handle			icon;			/* translator icon data */
    StringHandle	properties;		/* Properties for queued translations */
} emsTranslator, *emsTranslatorP, **emsTranslatorH;
/* ----- Menu Item Info --------------------- */
typedef struct emsMenu {
    long			size;			/* Size of this data structure */
    long			id;				/* ID of menu item to get info for */
    StringHandle	desc;			/* translator string description */
} emsMenu, *emsMenuP, **emsMenuH;
/* ----- Translation Data -------------------- */
typedef struct emsDataFile {
    long			size;			/* Size of this data structure */
    long			context;
    emsMIMEtypeH	mimeInfo;		/* MIME type of data to check */
    emsHeaderDataP	header;  		/* EMSF_BASIC_HEADERS & EMSF_ALL_HEADERS determine contents */
    FSSpec			file;			/* The input file name */
} emsDataFile, *emsDataFileP, **emsDataFileH;
/* ----- Resulting Status Data -------------- */
typedef struct emsResultStatus {
    long			size;			/* Size of this data structure */
    StringHandle	desc;			/* Returned string for display with the result */
    StringHandle	error;			/* Place to return string with error message */
    long			code;			/* Return for translator-specific result code */
} emsResultStatus, *emsResultStatusP, **emsResultStatusH;
/* ----- Progress Data ---------------------------- */
typedef struct emsProgressData {
    long			size;			/* Size of this data structure */
    long			value;			/* Range of Progress, percent complete */
    StringPtr		message;		/* Progress Message */
} emsProgressData, *emsProgressDataP, **emsProgressDataH;

/* ========== PROGRESS FUNCTION CALLBACK ================================ */

#if GENERATINGCFM
enum {
	emsProgressProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(emsProgressData*)))
};
typedef UniversalProcPtr EMSProgressUPP;
#define NewEMSProgressProc(userRoutine)		\
		(EMSProgressUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
		emsProgressProcInfo, GetCurrentArchitecture())
#define CallEMSProgressProc(userRoutine, data)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), emsProgressProcInfo, (data))
#else
typedef pascal short (*EMSProgressProcPtr)(emsProgressData *trans);
typedef EMSProgressProcPtr EMSProgressUPP;
#define NewEMSProgressProc(userRoutine) ((EMSProgressUPP) (userRoutine))
#define CallEMSProgressProc(userRoutine, data) (*(userRoutine))((data))
#endif

#define emsProgress EMSProgressUPP

/* ========== FUNCTION PROTOTYPES ======================================== */

/* ----- Get the API Version number this plugin implements ----------------- */
pascal long ems_plugin_version(
	Handle			globals,		/* In:  Return for allocated instance structure */
    short			*apiVersion		/* Out: Plugin Version */
);

/* ----- Initialize plugin and get its basic info -------------------------- */
pascal long ems_plugin_init(
    Handle			globals,		/* Out: Return for allocated instance structure */
    short			eudAPIVersion,	/* In:  The API version eudora is using */
    emsMailConfigP	mailConfig,		/* In:  Eudoras mail configuration */
    emsPluginInfoP	pluginInfo		/* Out: Return Plugin Information */
);

/* ----- Get details about a translator in a plugin ------------------------ */
pascal long ems_translator_info(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsTranslatorP	transInfo		/* In/Out: Return Translator Information */
);

/* ----- Check and see if a translation can be performed ------------------- */
pascal long ems_can_translate(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsTranslatorP	trans,			/* In:  Translator Info */
    emsDataFileP 	inTransData,	/* In:  What to translate */
    emsResultStatusP transStatus	/* Out: Translations Status information */
);

/* ----- Actually perform a translation on a file -------------------------- */
pascal long ems_translate_file(
    Handle			globals, 		/* Out: Return for allocated instance structure */
    emsTranslatorP	trans, 			/* In:  Translator Info */
    emsDataFileP	inFile,         /* In:  What to translate */
    EMSProgressUPP	progress,		/* Func to report progress/check for abort */
    emsDataFileP	outFile,		/* Out: Result of the translation */
    emsResultStatusP transStatus	/* Out: Translations Status information */
);

/* ----- End use of a plugin and clean up ---------------------------------- */
pascal long ems_plugin_finish(
    Handle			globals			/* Out: Return for allocated instance structure */
);

/* ----- Call the plug-ins configuration Interface ------------------------- */
pascal long ems_plugin_config(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsMailConfigP	mailConfig		/* In:  Eudora mail info */
);

/* ----- Manage properties for queued translations ------------------------- */
pascal long ems_queued_properties(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsTranslatorP	trans,			/* In/Out: The translator */
    long			*selected		/* In/Out: State of this translator */
);

/* ----- Info about menu hook to attach/insert composed object ------------- */
pascal long ems_attacher_info(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsMenuP		attachMenu		/* Out: The menu */
);

/* ----- Call an attacher hook to compose some special object -------------- */
pascal long ems_attacher_hook(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsMenuP		attachMenu,		/* In:  The menu */
    FSSpec			*attachDir,		/* In:  Location to put attachments */
    long			*numAttach,		/* Out: Number of files attached */
    emsDataFileH	*attachFiles	/* Out: Name of files written */
);

/* ----- Info about special menu items hooks ------------------------------- */
pascal long ems_special_info(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsMenuP		specialMenu		/* Out: The menu */
);

/* ----- Call a special menu item hook ------------------------------------- */
pascal long ems_special_hook(
    Handle			globals,		/* Out: Return for allocated instance structure */
    emsMenuP		specialMenu		/* In:  The menu */
);

#ifdef __cplusplus
}
#endif

#endif /* EMSAPI_MAC_H_INCLUDED */
