/* ======================================================================

	Functions to manage MIME type data structures for use
				 with Eudora translation API on the Mac.

	Filename:			MIMEType.h
	Last Edited:		March 7, 1997
	Authors:			Laurence Lundblade, Myra Callen, Bob Fronabarger
	Copyright:			1995, 1996 QUALCOMM Inc.
	Technical support:	<emsapi-info@qualcomm.com>
*/

emsMIMEtypeH  MakeMimeType(const StringPtr mimeType,
							 const StringPtr subType, const StringPtr mimeV);
emsMIMEtypeH  ParseMakeMimeType(const char *content_type);
void 	      FreeMimeType(emsMIMEtypeH mimeH);
Handle  	  StringMimeType(emsMIMEtypeH mimeH);
short         MatchMimeType(emsMIMEtypeH mimeH,
							 const StringPtr mType, const StringPtr subtype);

void          AddMimeParameter(emsMIMEtypeH mimeH,
							 const StringPtr name, const StringPtr value);
Handle        GetMimeParameter(emsMIMEtypeH mimeH, const StringPtr paramName);
Boolean		  RemoveMimeParameter(emsMIMEtypeH mimeH, const StringPtr name);

#define kContentTypeHdrCStr		"Content-Type:"
#define kContentTypeHdrLen		13
