/*____________________________________________________________________________
	TranslatorPrefs.h
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: TranslatorPrefs.h,v 1.6 1999/03/10 03:04:13 heller Exp $
____________________________________________________________________________*/

#pragma once
 
#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	PGPUInt32			numAlgs;
	PGPCipherAlgorithm	algs[ 20 ];
} PreferredAlgorithmsStruct;

void		RefreshPrefs( void );
Boolean		PrefShouldUsePGPMimeEncrypt( void );
Boolean		PrefShouldUsePGPMimeSign( void );
Boolean		PrefShouldBreakLines( ulong *lineLength );

ulong		PrefGetSigningPassphraseCacheSeconds( void );
ulong		PrefGetEncryptionPassphraseCacheSeconds( void );

Boolean		PrefGetComment( char comment[ 256 ] );

PGPCipherAlgorithm	PrefGetConventionalCipher( void );

void		PrefGetPreferredAlgorithms( PreferredAlgorithmsStruct *algs );



#ifdef __cplusplus
}
#endif