/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CPGPtoolsCryptoTask.h,v 1.19 1999/03/10 02:37:57 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "MacSecureMemory.h"
#include "WarningAlertTypes.h"

#include "PGPtools.h"
#include "pgpEncode.h"
#include "pgpUserInterface.h"
#include "PGPSharedEncryptDecrypt.h"
#include "CResultsTable.h"
#include "pgpClientLib.h"

struct PGPKeySpec;
class CPGPtoolsTaskProgressDialog;
class LArray;
class CPGPtoolsPassphraseList;

#include "CPGPtoolsTask.h"

/*____________________________________________________________________________
	The encode/decode params should contain only information need by a
	task to set up and get started.  It should not be used for callback info.
____________________________________________________________________________*/
class CEncodeDecodeParams
{
public:
	CPGPtoolsTaskProgressDialog	*progressDialog;
	PGPKeySetRef				allKeys;
	
	CEncodeDecodeParams( void )
	{
		progressDialog		= NULL;
		allKeys				= kInvalidPGPKeySetRef;
	}
	virtual ~CEncodeDecodeParams( void )
	{
	}
};


class CDecodeParams : public CEncodeDecodeParams
{
public:
	CPGPtoolsPassphraseList		*passphraseList;
	
	CDecodeParams( void ) : CEncodeDecodeParams()
	{
		passphraseList		= NULL;
	}
} ;

class CEncodeParams : public CEncodeDecodeParams
{
public:
	PGPOptionListRef			encodeOptions;
	Boolean						encrypting;
	Boolean						conventionalEncrypt;
	Boolean						signing;
	Boolean						detachedSignature;
	Boolean						textOutput;
	Boolean						wipeOriginal;
	Boolean						encryptingToSelf;
	Boolean						signingWithSplitKey;
	Boolean						fyeo;
	Boolean						selfDecryptingArchive;
	PGPKeyRef					signingKey;
	PGPLocalEncodingFlags		encodingFlags;
	CSecureCString256			conventionalPassphrase;
	CSecureCString256			signingPassphrase;
	PGPByte						*signingPasskey;
	PGPSize						signingPasskeySize;
	
	CEncodeParams( void )
		: CEncodeDecodeParams()
	{
		encodeOptions			= kInvalidPGPOptionListRef;
		encrypting				= FALSE;
		signing					= FALSE;
		wipeOriginal			= FALSE;
		detachedSignature		= FALSE;
		textOutput				= FALSE;
		signingWithSplitKey		= FALSE;
		fyeo					= FALSE;
		selfDecryptingArchive	= FALSE;
		signingKey				= kInvalidPGPKeyRef;
		signingPasskey			= NULL;
		signingPasskeySize		= 0;
	}
	
	virtual ~CEncodeParams( void )
	{
		if( PGPOptionListRefIsValid( encodeOptions ) )
			PGPFreeOptionList( encodeOptions );
			
		if( IsntNull( signingPasskey ) )
			PGPFreeData( signingPasskey );
	}
	
} ;




class CPGPtoolsCryptoTask : public CPGPtoolsTask
{
public:
						CPGPtoolsCryptoTask(PGPtoolsOperation operation);
	virtual				~CPGPtoolsCryptoTask(void);

	virtual	CToolsError	DecryptVerify(PGPContextRef context,
								PGPtlsContextRef tlsContext,
								CDecodeParams *state) = 0;
	virtual	CToolsError	EncryptSign(PGPContextRef context,
								PGPtlsContextRef tlsContext,
								CEncodeParams *state) = 0;
	
protected:

	PGPContextRef			mContext;
	PGPtlsContextRef		mTLSContext;
	UInt32					mBadPassphraseCount;
	PGPAnalyzeType			mDataType;
	PGPtoolsSignatureData	mSignatureData;
	Boolean					mSignatureDataValid;
	
	class CEventHandlerData
	{
	public:
		enum { kMagic = 'EHND' };
		OSType					mMagic;
		CPGPtoolsCryptoTask *	mTask;
		CEncodeDecodeParams *	mParams;
		
		CEventHandlerData( CPGPtoolsCryptoTask *task,
				CEncodeDecodeParams *params )
		{
			mMagic	= kMagic;
			mTask	= task;
			mParams	= params;
		}
		
		virtual ~CEventHandlerData(void) {}
	} ;
	
	class CDecodeEventHandlerData : public CEventHandlerData
	{
	public:
		Boolean							retryingSigVerification;
		LArrayIterator *				passphraseIterator;
		Boolean							isFYEO;
		void *							outputData;
		PGPSize							outputDataSize;

		PGPClientDecodeEventHandlerData	clientHandlerData;
		
		CDecodeEventHandlerData( PGPContextRef context,
			PGPtlsContextRef tlsContext,
			CPGPtoolsCryptoTask *task, CDecodeParams *state)
			: CEventHandlerData( task, state )
		{
			PGPError	err;
			
			retryingSigVerification	= FALSE;
			passphraseIterator		= NULL;
			isFYEO					= FALSE;
			outputData				= NULL;
			outputDataSize			= 0;
			
			err = PGPInitClientDecodeEventHandlerData(
						context, tlsContext,
						state->allKeys,
						&clientHandlerData );
			pgpAssertNoErr( err );
		};

		virtual ~CDecodeEventHandlerData(void)
		{
			PGPCleanupClientDecodeEventHandlerData(
				&clientHandlerData );
		};
	} ;
	
	class CEncodeEventHandlerData : public CEventHandlerData
	{
	public:
		CEncodeEventHandlerData( CPGPtoolsCryptoTask *task,
			CEncodeDecodeParams *state )
			: CEventHandlerData( task, state )
		{
		}
	} ;
	
	virtual	PGPError	NullEvent( PGPEvent *event,
							CEventHandlerData *data);
								
	virtual PGPError	GenericEventHandler( PGPEvent *event,
							CEventHandlerData *state);
							
	virtual PGPError	DecodeEventHandler( PGPEvent *event,
							CDecodeEventHandlerData *state);
							
	virtual PGPError	EncodeEventHandler( PGPEvent *event,
								CEncodeEventHandlerData *data);
								
	virtual	PGPError	DecodeAnalyzeEvent(PGPEvent *event,
								CDecodeEventHandlerData *data);
								
	virtual	PGPError	DecodePassphraseEvent(
								PGPEvent *event,
								CDecodeEventHandlerData *data);
								
	virtual	PGPError	DecodeRecipientsEvent(
								PGPEvent *event,
								CDecodeEventHandlerData *data);

	virtual	PGPError	DecodeSignatureEvent(
								PGPEvent *event,
								CDecodeEventHandlerData *data);
								
	virtual	void		GetDecryptPassphrasePromptString(StringPtr prompt) = 0;
	
	static OSStatus		sProgressCallbackProc(UInt32 bytesProcessed,
								UInt32 totalBytesToProcess, void *userData);
								
	static PGPError		sEncodeEventHandlerProc(PGPContextRef context,
								PGPEvent *event, PGPUserValue userValue);
	static PGPError		sDecodeEventHandlerProc(PGPContextRef context,
								PGPEvent *event, PGPUserValue userValue);
							
};


