/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CPGPtoolsTextWindow.cp,v 1.6 1999/03/10 02:38:33 heller Exp $
____________________________________________________________________________*/

#include <Appearance.h>
#include <LTextEditView.h>
#include <PP_Messages.h>

#include "CPGPtoolsTextWindow.h"

const PaneIDT	kScrollPaneID	= 4001;
const PaneIDT	kTextEditPaneID	= 4002;

CPGPtoolsTextWindow::CPGPtoolsTextWindow(LStream *inStream)
	: CPGPtoolsWindow(inStream)
{
}

CPGPtoolsTextWindow::~CPGPtoolsTextWindow(void)
{
}

	void
CPGPtoolsTextWindow::FinishCreateSelf(void)
{
	LTextEditView	*textEdit;
	
	CPGPtoolsWindow::FinishCreateSelf();

	SetThemeWindowBackground( GetMacPort(), kThemeDocumentWindowBackgroundBrush,
				FALSE );

	textEdit = (LTextEditView *) FindPaneByID( kTextEditPaneID );
	pgpAssertAddrValid( textEdit, LTextEditView );
	
	TEAutoView( TRUE, textEdit->GetMacTEH() );
}

	void
CPGPtoolsTextWindow::ApplyForeAndBackColors(void) const
{
	SetThemeWindowBackground( GetMacPort(), kThemeDocumentWindowBackgroundBrush,
				FALSE );
}


	OSStatus
CPGPtoolsTextWindow::SetText(LogicalAddress theText, UInt32 textLength)
{
	LTextEditView	*textEdit;
	
	pgpAssert( textLength <= max_Int16 );
	
	if( textLength > max_Int16 )
		textLength = max_Int16;
		
	textEdit = (LTextEditView *) FindPaneByID( kTextEditPaneID );
	pgpAssertAddrValid( textEdit, LTextEditView );
	
	textEdit->SetTextPtr( (char *) theText, textLength );
	
	return( noErr );
}

	void
CPGPtoolsTextWindow::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	outUsesMark = false;

	switch (inCommand)
	{
		case cmd_SelectAll:
			outEnabled = TRUE;
			break;
			
		default:
			CPGPtoolsWindow::FindCommandStatus(inCommand, outEnabled,
									outUsesMark, outMark, outName);
			break;
	}
}

	Boolean
CPGPtoolsTextWindow::ObeyCommand(
	CommandT	inCommand,
	void*		ioParam)
{
	Boolean		cmdHandled = true;
	
	switch (inCommand)
	{
		case cmd_SelectAll:
		{
			LTextEditView	*textEdit;
			
			textEdit = (LTextEditView *) FindPaneByID( kTextEditPaneID );
			pgpAssertAddrValid( textEdit, LTextEditView );

			SwitchTarget( textEdit );
			textEdit->SelectAll();
			break;
		}
		
		default:
			cmdHandled = CPGPtoolsWindow::ObeyCommand( inCommand, ioParam );
			break;
	}
	
	return cmdHandled;
}
