/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CWipeFreeSpaceWizardDialog.h,v 1.15 1999/03/10 02:42:00 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LBroadcaster.h>
#include <LGADialog.h>
#include <LPeriodical.h>

typedef struct WipeVolumeInfo
{
	short	vRefNum;
	Str63	name;
	ushort	signature;
	short	driveNumber;
	short	driverRefNum;
	Boolean	canWipe;
	
} WipeVolumeInfo;

// It is assumed that this enum is kept in user presentation order.
typedef enum WipeFreeSpaceView
{
	kWipeFreeSpaceView_Invalid			= 1,
	kWipeFreeSpaceView_Error,
	kWipeFreeSpaceView_IntegrityFailure,
	kWipeFreeSpaceView_VersionFailure,
	kWipeFreeSpaceView_Introduction,
	kWipeFreeSpaceView_SelectVolume,
	kWipeFreeSpaceView_UnmountHFSFailure,
	kWipeFreeSpaceView_UnmountHFSPlusFailure,
	kWipeFreeSpaceView_Wiping,
	kWipeFreeSpaceView_Conclusion,
	kWipeFreeSpaceView_Exit			// Not a real view
	
} WipeFreeSpaceView;

class CWipeFreeSpaceWizardView;
class LPushButton;

class CWipeFreeSpaceWizardDialog : 	public LGADialog,
									public LPeriodical
{
public:
	enum { class_ID = 'WFSW' };
	
						CWipeFreeSpaceWizardDialog(LStream *inStream);
	virtual				~CWipeFreeSpaceWizardDialog();

	virtual void		ApplyForeAndBackColors(void) const;
	virtual void		FindCommandStatus(CommandT inCommand,
								Boolean &outEnabled, Boolean &outUsesMark,
								Char16 &outMark, Str255 outName);
	virtual	void		ListenToMessage(MessageT inMessage, void *ioParam);
	void				SetParams(PGPContextRef context);
	virtual void		SpendTime(const EventRecord &inMacEvent);

	static void			SetNewView(WipeFreeSpaceView newView);
	static void			SetError(PGPError err);

protected:

	virtual	void		FinishCreateSelf(void);

private:

	PGPContextRef				mContext;
	WipeFreeSpaceView			mCurrentView;
	CWipeFreeSpaceWizardView	*mCurrentViewObj;
	LPushButton					*mNextButton;
	LPushButton					*mPreviousButton;
	LPushButton					*mCancelButton;
	WipeVolumeInfo				mWipeVolInfo;
	PGPUInt32					mWipingPasses;
	
	static WipeFreeSpaceView	mNewView;
	static PGPError				mError;
	
	void				AdjustControlsForView(WipeFreeSpaceView theView);
	void				EnterView(WipeFreeSpaceView newView);
	WipeFreeSpaceView	GetNextView(WipeFreeSpaceView theView);
	WipeFreeSpaceView	GetPreviousView(WipeFreeSpaceView theView);
	WipeFreeSpaceView	LeaveCurrentView(WipeFreeSpaceView newView);
	void				SwitchToView(WipeFreeSpaceView newView);
	Boolean				ValidateCurrentView(void);
};

