#pragma once

#include <LAttachment.h>
#include <LAttachable.h>

/*	---------------------------------------------------------------------------------------------
	ABalloon		PowerPlant attachment class for balloon help
	
	Author: James W. Walker <mailto:jwwalker@kagi.com>
	
	Creation date: 2/26/98
	
	Last Modified: 4/11/98
	
	Purpose:	To assign help balloons to panes in a PowerPlant
				window.  You can use different messages depending
				on whether the item is on or off, enabled or disabled.
				
	Usage:		Attach an ABalloon to each pane (usually a control)
				for which you want to provide balloon help.
				Specify a STR# ID and a string index for each state.
				And remember to register ABalloon at startup.
				You must compile with RTTI for proper function.
	
	Overriding:	The most likely methods to override are ComputeTip
				(to provide more appropriate placement of the
				balloon tip) and ComputeStringIndex (if you have
				more than the 4 states I provided for.)
			
	Restrictions:	ABalloon is (C)1998 by James W. Walker.
				Permission is granted for use of ABalloon
				free of charge, other than acknowledgement of
				James W. Walker in any program using ABalloon
				(perhaps in an About box or in accompanying
				documentation).
	
	Change history:
		1.0  2/28/98		First release.
		1.1  4/11/98
				- Don't show balloons for invisible panes
				  (Thanks, Daniel Chiaramello, for the correction)
				- Rolled ABalloonHelper::CreateABalloonHelper into
				  ABalloonHelper::AddABalloon.
				- sBalloonAttachments is now a TArray<ABalloon*>
				  instead of TArray<LAttachment*>.
				- In the HMShowBalloon call, use kHMRegularWindow
				  instead of kHMSaveBitsNoWindow, because IM says
				  that the former should normally be used.
	---------------------------------------------------------------------------------------------
*/
class ABalloon : public LAttachment
{
	friend class ABalloonHelper;
	
public:
	enum { class_ID = 'ABal' };
	
					ABalloon(
							LStream			*inStream);
					
					~ABalloon();
					
protected:

	virtual void	DoBalloon();
	
	virtual Int16	ComputeStringIndex( LPane* inPane );
	
	virtual void	ShowBalloon( Int16 inStringIndex, Rect& inAltRect );
	
	virtual Point	ComputeTip( const Rect& inAltRect );
	
	
	ResIDT	mStringListID;
	Int16	mOffDisabledIndex;
	Int16	mOffEnabledIndex;
	Int16	mOnDisabledIndex;
	Int16	mOnEnabledIndex;
	
	static	LAttachable*	sLastBalloonedItem;
	static	Int16			sLastIndex;
	static	ResIDT			sLastStringList;
};
