/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPEncoderDecoder.h,v 1.25 1999/03/10 12:22:25 jason Exp $
____________________________________________________________________________*/

#pragma once 

#include <PP_Types.h>

#include "PGPclientLib.h"
#include "MacCursors.h"
#include "CPGPException.h"
#include "CString.h"
#include "PGPEncode.h"
#include "PassphraseCache.h"


typedef struct SDecodeSection {
	void *					buf;
	PGPSize					size;
	PGPKeySetRef			addKeysSet;
	PGPEventSignatureData	sigData;
	Boolean					sigDataValid;
	Boolean					encrypted;
} **SDecodeSectionHandle;

enum {
	encodeOptions_Encrypt			= (1L << 0),
	encodeOptions_Sign				= (1L << 1),
	encodeOptions_TextOutput		= (1L << 2),
	encodeOptions_TreatInputAsText	= (1L << 3),
	encodeOptions_ClearSign			= (1L << 4),
	encodeOptions_ConvEncrypt		= (1L << 5)
};

typedef OptionBits	EEncodeOptions;


class CPGPEncoderDecoder {
public:
	static void						Init(PGPContextRef inContext);
	static void						Cleanup();
	
	static Boolean					EncodeHandle(PGPContextRef inContext,
										Handle ioDataH,
										EEncodeOptions inOptions,
										UInt32 inNumRecipients = 0,
										const PGPRecipientSpec *
											inRecipientList	= nil,
										Boolean inUseCache = false);
	static Boolean					DecodeHandle(PGPContextRef inContext,
										Handle inDataH,
										PGPKeySetRef inKeySet,
										SDecodeSectionHandle &
												outDecodeSectionsHandle,
										Boolean * outFYEO,
										Boolean inUseCache = false);
								
	static void						FreeDecodeSection(
										SDecodeSection * inSection);
	
protected:
	static Boolean					sCheckForMissingKeys;
	static CSignPassphraseCache *	sSigningPassphraseCache;
	static CSignPassphraseCache *	sDecryptPassphraseCache;
	static PGPtlsContextRef			sTLSContext;
	
								
	static PGPOptionListRef			CreateOptionList(
										PGPContextRef inContext,
										EEncodeOptions inOptions,
										PGPKeySetRef inRecipients,
										PGPKeyRef inSigningKey,
										char * inConvEncryptPassphrase,
										void * inPassBuffer,
										PGPSize inPassKeySize,
										Boolean inUsePassphrase);
													
	static void						SetPassbufferCache(
										Boolean inSigning,
										PGPKeyRef inKey,
										PGPBoolean inUsePassphrase,
										void * inBuffer,
										PGPSize inPasskeySize);

	static void						ShowError(CPGPException & inErr);
	
	static PGPError					PGPEncodeEventHandler(
										PGPContextRef inContext,
										PGPEvent * inEventP,
										PGPUserValue inUserValue)
										{ (void) inContext; (void) inEventP;
										  AnimateCursor((AnimatedCursorRef)
												inUserValue);
										  return kPGPError_NoErr; }
	static PGPError					PGPDecodeEventHandler(
										PGPContextRef inContext,
										PGPEvent * inEventP,
										PGPUserValue inUserValue);
};

const ResIDT	acur_BeachBall						=	12121;

