/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPassphraseCache.h,v 1.3 1999/03/10 02:35:17 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "PGPKeys.h"
#include "CString.h"



struct SPassphraseCacheItem {
	UInt32			tickCount;
	PGPKeyRef		key;
	CString *		passphrase;
};



class CPassphraseCache {
public:
							CPassphraseCache();
	virtual					~CPassphraseCache();
	
	void					AddOrUpdateItem(UInt32 inTickCount, PGPKeyRef inKey,
									const char * inPassphrase);
	void					RemoveItem(PGPKeyRef inKey);
	SPassphraseCacheItem *	FindItem(PGPKeyRef inKey);
	
	void					ClearCache();

protected:
	SPassphraseCacheItem *	mCache;
	SInt32					mCount;
	PGPKeySetRef			mKeySet;
	
	void					WipeCache();
	
	SInt32					FindItemIndex(PGPKeyRef inKey);
	
	PGPKeyRef				FindKeyInOtherKeySet(PGPKeyRef inKey,
									PGPKeySetRef inKeySet);
};