/*____________________________________________________________________________
	Copyright (C) 1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPAMEditTextImp.cp,v 1.2 1999/03/10 02:36:20 heller Exp $
____________________________________________________________________________*/

#include <Appearance.h>
#include <LEditText.h>

#include "CPGPAMEditTextImp.h"


CPGPAMEditTextImp::CPGPAMEditTextImp(LControlPane *inControlPane)
		: LAMEditTextImp( inControlPane )
{
}

CPGPAMEditTextImp::CPGPAMEditTextImp(LStream *inStream)
		: LAMEditTextImp( inStream )
{
}

CPGPAMEditTextImp::~CPGPAMEditTextImp(void)
{
}

	void
CPGPAMEditTextImp::DrawSelf(void)
{
	// Current PowerPlant implementation does not redraw frame correctly
	// when erasing the focus. Do so here.

	LAMEditTextImp::DrawSelf();
	
	if( ! ( (LEditText *) mControlPane )->HasFocusRing() )
	{
		Rect			frame;
		ThemeDrawState	state = kThemeStateDisabled;
		
		if ( IsActive() && IsEnabled() )
		{
			state = kThemeStateActive;
		}
		
		CalcLocalFrameRect( frame );
		InsetRect( &frame, 3, 3 );
		DrawThemeEditTextFrame( &frame, state );
	}
}