/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPOptionsGrafPort.cp,v 1.9 1999/04/04 11:13:44 wprice Exp $
____________________________________________________________________________*/

// Public includes:
#include <LCheckBox.h>
#include <LPopupButton.h>
#include <LPushButton.h>
#include <UDrawingState.h>
#include <UGAColorRamp.h>

#include "CComboError.h"
#include "MacStrings.h"
#include "pgpMem.h"

// Private includes:
#include "CPGPCheckboxOptionView.h"
#include "CPGPPopupMenuOptionView.h"
#include "CPGPOptionsGrafPort.h"
#include "CPGPOptionsListView.h"
#include "pgpDialogs.h"
#include "pgpOptionListPriv.h"

const PaneIDT	kOptionsListViewPaneID = 'OLST';

CPGPOptionsGrafPort::CPGPOptionsGrafPort(LStream *inStream)
	: CPGPUIGrafPortView(inStream)
{
	mOptions = NULL;
}

CPGPOptionsGrafPort::~CPGPOptionsGrafPort()
{
}

	void
CPGPOptionsGrafPort::UpdatePort(void)
{
	StColorPortState	savePortState( GetMacPort() );
	RGBColor			foreColor;
	RGBColor			backColor;
	
	// Revert to dark gray to erase the window background
	foreColor = UGAColorRamp::GetBlackColor();
	backColor = UGAColorRamp::GetColor( colorRamp_Gray2 );

	RGBForeColor( &foreColor );
	RGBBackColor( &backColor );
	
	CPGPUIGrafPortView::UpdatePort();
}

	void
CPGPOptionsGrafPort::DrawSelf(void)
{
	StColorState	saveColors;
	RGBColor		foreColor;
	RGBColor		backColor;
	
	// Revert to dark gray to draw the window background
	foreColor = UGAColorRamp::GetBlackColor();
	backColor = UGAColorRamp::GetColor( colorRamp_Gray2 );

	RGBForeColor( &foreColor );
	RGBBackColor( &backColor );

	CPGPUIGrafPortView::DrawSelf();
}

	void
CPGPOptionsGrafPort::FinishCreateSelf(void)
{
	RGBColor	foreColor;
	RGBColor	backColor;
	
	CPGPUIGrafPortView::FinishCreateSelf();
	
	mOptionsListView = (CPGPOptionsListView *)
							FindPaneByID( kOptionsListViewPaneID );
	pgpAssertAddrValid( mOptionsListView, VoidAlign );

	foreColor = UGAColorRamp::GetBlackColor();
	backColor = UGAColorRamp::GetColor( colorRamp_Gray1 );

	SetForeAndBackColors( &foreColor, &backColor );
	ApplyForeAndBackColors();
}

	void
CPGPOptionsGrafPort::AppendOptionView(
	CPGPOptionView 	*theView,
	SInt32			viewOffset)
{
	pgpAssertAddrValid( mOptionsListView, VoidAlign );
	mOptionsListView->AppendOptionView( theView, viewOffset );
}

	void
CPGPOptionsGrafPort::BuildOptionsView(
	CPGPOptionView		*owningView,
	PGPOptionListRef	optionList,
	SInt32				viewOffset)
{
	PGPUInt32	optionIndex	= 0;
	PGPOption	optionData;
	
	/* Build list of checkboxes and/or popups */
	
	while( IsntPGPError( pgpGetIndexedOption( optionList,
					optionIndex, FALSE, &optionData ) ) )
	{
		if( optionData.type == kPGPOptionType_Checkbox )
		{
			PGPOUICheckboxDesc		*descriptor;
			CPGPCheckboxOptionView	*checkboxView;
			
			descriptor = (PGPOUICheckboxDesc *) optionData.value.asPtr;

			checkboxView = CPGPCheckboxOptionView::
								CreateCheckboxOptionView(mOptionsListView,
									descriptor );
			if( IsntNull( checkboxView ) )
			{
				mOKButton->AddListener( checkboxView );

				AppendOptionView( checkboxView, viewOffset );
				
				if( owningView != NULL )
					checkboxView->AddListener( owningView );
					
				if( optionData.subOptions != NULL )
				{
					BuildOptionsView( checkboxView, optionData.subOptions,
							viewOffset + 20 );
				}
			}
		}
		else if( optionData.type == kPGPOptionType_PopupList )
		{
			PGPOUIPopupListDesc		*descriptor;
			CPGPPopupMenuOptionView	*popupView;
			
			descriptor = (PGPOUIPopupListDesc *) optionData.value.asPtr;

			popupView = CPGPPopupMenuOptionView::
								CreatePopupMenuOptionView(
									mOptionsListView, descriptor );
			if( IsntNull( popupView ) )
			{
				mOKButton->AddListener( popupView );

				AppendOptionView( popupView, viewOffset );

				if( owningView != NULL )
					popupView->AddListener( owningView );
					
				if( optionData.subOptions != NULL )
				{
					BuildOptionsView( popupView, optionData.subOptions,
							viewOffset + 20 );
				}
			}
		}
		
		++optionIndex;
	}
}

	PGPError
CPGPOptionsGrafPort::SetOptions(
	PGPContextRef 				context,
	CPGPOptionsDialogOptions 	*options)
{
	PGPError	err = kPGPError_NoErr;
	
	err = CPGPUIGrafPortView::SetOptions( context, options );
	if( IsntPGPError( err ) )
	{
		mOptions = options;
		
		BuildOptionsView( NULL, options->mClientOptions, 0 );
	}
	
	return( err );
}