/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPsdkUILibDialogs.cp,v 1.6 1999/03/10 02:55:53 heller Exp $
____________________________________________________________________________*/

#include <Gestalt.h>
#include <LowMem.h>
#include <Sound.h>

#include <LStaticText.h>
#include <PP_Messages.h>
#include <UGAColorRamp.h>
	
#include "MacDebugLeaks.h"
#include "MacEnvirons.h"
#include "pgpMem.h"
#include "MacStrings.h"

#include "CPGPModalGrafPortView.h"
#include "PGPsdkUILibDialogs.h"


	static MessageT
PGPUIWarningAlertInternal(
	ResIDT				dialogResID,
	ConstStr255Param	string)
{
	MessageT		dismissMessage = msg_Nothing;
	GrafPtr			savePort;
	DialogRef		warnDialog;
	
	GetPort( &savePort );
	
	// Create standard Macintosh window and overlay PowerPlant onto it
	warnDialog = CPGPModalGrafPortView::CreateDialog( dialogResID);
	if( IsntNull( warnDialog ) )
	{
		CPGPModalGrafPortView	*warnGrafPortView;
		
		warnGrafPortView = (CPGPModalGrafPortView *) GetWRefCon( warnDialog );
		
		if ( IsntNull( string ) )
		{
			LStaticText *	caption	= NULL;
			
			#define kMessagePaneID	'cMSG'
			
			caption	= (LStaticText *) warnGrafPortView->FindPaneByID(
								kMessagePaneID );
			if ( IsntNull( caption ) )
			{
				caption->SetDescriptor( string );
			}
		}
		
		(void) warnGrafPortView->DoDialog();
		
		dismissMessage = warnGrafPortView->GetDismissMessage();
		
		delete warnGrafPortView;
		DisposeDialog( warnDialog );
	}
	else
	{
		pgpDebugMsg( "PGPUIWarningAlert(): Failed to get dialog" );
		dismissMessage = msg_Nothing;
	}
	
	SetPort( savePort );

	return( dismissMessage );
}

#if 0	// Keep
	static MessageT
PGPUIWarningAlertInternal(
	ResIDT				dialogResID,
	ConstStr255Param	string)
{
	MessageT		dismissMessage = msg_Nothing;
	GrafPtr			savePort;
	Boolean			showPPAlert = TRUE;
	
	GetPort( &savePort );
		
	if( HaveAppearanceMgr() &&
		( dialogResID == kPGPUIGenericOKCancelAlert ||
			dialogResID == kPGPUIGenericOKAlert ) )
	{
		AlertStdAlertParamRec	alertParams;
		SInt16					itemHit;
		
		pgpClearMemory( &alertParams, sizeof( alertParams ) );
		
		alertParams.defaultText		= (StringPtr) kAlertDefaultOKText;
		alertParams.defaultButton	= kAlertStdAlertOKButton;
		alertParams.position		= kWindowAlertPositionMainScreen;
		
		if( dialogResID == kPGPUIGenericOKCancelAlert )
		{
			alertParams.cancelText		=(StringPtr)  kAlertDefaultCancelText;
			alertParams.cancelButton	= kAlertStdAlertCancelButton;
		}

		if( StandardAlert( kAlertCautionAlert, (StringPtr) string, NULL,
					&alertParams, &itemHit ) == noErr )
		{
			showPPAlert = FALSE;
		}
				
		if( itemHit == kAlertStdAlertOKButton )
		{
			dismissMessage = msg_OK;
		}
		else
		{
			dismissMessage = msg_Cancel;
		}
	}
	
	if( showPPAlert )
	{
		DialogRef		warnDialog;
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		warnDialog = CPGPModalGrafPortView::CreateDialog( dialogResID);
		if( IsntNull( warnDialog ) )
		{
			CPGPModalGrafPortView	*warnGrafPortView;
			
			warnGrafPortView = (CPGPModalGrafPortView *) GetWRefCon(
											warnDialog );
			
			if ( IsntNull( string ) )
			{
				LStaticText *	caption	= NULL;
				
				#define kMessagePaneID	'cMSG'
				
				caption	= (LStaticText *) warnGrafPortView->FindPaneByID(
									kMessagePaneID );
				if ( IsntNull( caption ) )
				{
					caption->SetDescriptor( string );
				}
			}
			
			(void) warnGrafPortView->DoDialog();
			
			dismissMessage = warnGrafPortView->GetDismissMessage();
			
			delete warnGrafPortView;
			DisposeDialog( warnDialog );
		}
		else
		{
			pgpDebugMsg( "PGPUIWarningAlert(): Failed to get dialog" );
			dismissMessage = msg_Nothing;
		}
		
	}
	
	SetPort( savePort );
	
	return( dismissMessage );
}
#endif


	MessageT
PGPUIWarningAlert(ResIDT dialogResID)
{
	return( PGPUIWarningAlertInternal( dialogResID, NULL ) );
}



	MessageT
PGPUIWarningAlert(
	ResIDT				dialogResID,
	ConstStr255Param	baseString,
	ConstStr255Param	str1,
	ConstStr255Param	str2,
	ConstStr255Param	str3 )
{
	Str255		msg;
	
	InsertPStrings( baseString, str1, str2, str3, msg );
	
	return( PGPUIWarningAlertInternal( dialogResID, msg ) );
}


	
	MessageT
PGPUIWarningAlert(
	ResIDT				dialogResID,
	ResID				stringListResID,
	short				stringListIndex,
	ConstStr255Param	str1,
	ConstStr255Param	str2 ,
	ConstStr255Param	str3 )
{
	Str255		baseString;
	Str255		msg;
	
	GetIndString( baseString, stringListResID, stringListIndex );
	InsertPStrings( baseString, str1, str2, str3, msg );
	
	return( PGPUIWarningAlertInternal( dialogResID, msg ) );
}
















