/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CMacTCPInternetUtilities.cp,v 1.12 1999/03/10 02:34:39 heller Exp $
____________________________________________________________________________*/

#include <Devices.h>
#include <string.h>

#include "pgpMem.h"

#include "CMacTCPInternetUtilities.h"



class StResolverBusy {
public:
					StResolverBusy();
	virtual			~StResolverBusy();

protected:
	static Boolean	sResolverBusy;
};



UniversalProcPtr	CMacTCPInternetUtilities::sResultProc = nil;
PGPInternetAddress	CMacTCPInternetUtilities::sLocalAddress;
Boolean				StResolverBusy::sResolverBusy = false;


StResolverBusy::StResolverBusy()
{
	while (sResolverBusy) {
		ThrowIfPGPError_(CSocket::CallIdleEventHandler());
	}
	
	sResolverBusy = true;
}



StResolverBusy::~StResolverBusy()
{
	sResolverBusy = false;
}


CMacTCPInternetUtilities::CMacTCPInternetUtilities()
{
	OSStatus	err;
	
	sLocalAddress.s_addr = 0;
	
	sResultProc = NewResultProc(ResultProc);
	if (sResultProc == nil) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}

	err = ::OpenResolver(nil);
	if (err != noErr) {
		ThrowPGPError_(err);
	}
}



CMacTCPInternetUtilities::~CMacTCPInternetUtilities()
{
	StResolverBusy busyResolver;
	
	::CloseResolver();
	if (sResultProc != nil) {
		::DisposeRoutineDescriptor(sResultProc);
	}
}



	PGPHostEntry *
CMacTCPInternetUtilities::GetHostByName(
	const char *	inName)
{
	SThreadContext *	theContext = CSocket::GetThreadContext();
	PGPHostEntry *		result = nil;
	OSStatus			err;
	Boolean				done = false;
	struct hostInfo		hInfo;	
	StResolverBusy		busyResolver;

	err = ::StrToAddr(	(char *) inName,
						&hInfo,
						sResultProc,
						(char *) &done);
	
	// Delay if we have to query the name server
	if (err == cacheFault) {
		while (! done) {
			ThrowIfPGPError_(CSocket::CallIdleEventHandler());
		}
		err = hInfo.rtnCode;
	}
	if (err != noErr) {
		ThrowPGPError_(err);
	}

	// Insert the name
	strncpy(theContext->hostEntry.h_name, hInfo.cname, kMaxHostNameLen);
	theContext->hostEntry.h_name[kMaxHostNameLen] = 0;
	::BlockMoveData(	hInfo.addr,
						theContext->hAddressesBuffer,
						sizeof(theContext->hAddressesBuffer));
	pgpClearMemory(	theContext->hAddressesListBuffer,
					sizeof(theContext->hAddressesListBuffer));
	for (UInt8 i = 0; (i < kMaxHostAddrs)
	  && (theContext->hAddressesBuffer[i] != 0); i++) {
		theContext->hAddressesListBuffer[i] =
			&theContext->hAddressesBuffer[i];
	}
	result = &theContext->hostEntry;

	return result;
}



	PGPHostEntry *
CMacTCPInternetUtilities::GetHostByAddress(
	PGPInternetAddress	inAddress)
{
	SThreadContext *	theContext = CSocket::GetThreadContext();
	PGPHostEntry *		result = nil;
	OSStatus			err;
	Boolean				done = false;
	struct hostInfo		hInfo;
	StResolverBusy		busyResolver;
	
	err = ::AddrToName(	inAddress.s_addr,
						&hInfo,
						sResultProc,
						(char *) &done);
						
	// Delay if we have to query the name server
	if (err == cacheFault) {
		while (! done) {
			ThrowIfPGPError_(CSocket::CallIdleEventHandler());
		}
		err = hInfo.rtnCode;
	}
	if (err != noErr) {
		ThrowPGPError_(err);
	}

	// Insert the name
	strncpy(theContext->hostEntry.h_name, hInfo.cname, kMaxHostNameLen);
	theContext->hostEntry.h_name[kMaxHostNameLen] = 0;
	theContext->hAddressesBuffer[0] = inAddress.s_addr;
	theContext->hAddressesBuffer[1] = 0;
	pgpClearMemory(	theContext->hAddressesListBuffer,
					sizeof(theContext->hAddressesListBuffer));
	for (UInt8 i = 0; (i < NUM_ALT_ADDRS)
	  && (theContext->hAddressesBuffer[i] != 0); i++) {
		theContext->hAddressesListBuffer[i] =
			&theContext->hAddressesBuffer[i];
	}
	result = &theContext->hostEntry;

	return result;
}



	void
CMacTCPInternetUtilities::GetHostName(
	char *	outName,
	SInt32	inNameLength)
{
	PGPInternetAddress	localAddress = GetLocalAddress();
	OSStatus			err;
	Boolean				done = false;
	struct hostInfo		hInfo;
	StResolverBusy		busyResolver;
	
	err = ::AddrToName(	localAddress.s_addr,
						&hInfo,
						sResultProc,
						(char *) &done);
						
	// Delay if we have to query the name server
	if (err == cacheFault) {
		while (! done) {
			ThrowIfPGPError_(CSocket::CallIdleEventHandler());
		}
		err = hInfo.rtnCode;
	}
	if (err != noErr) {
		ThrowPGPError_(err);
	}

	// Insert the name
	strncpy(outName, hInfo.cname, inNameLength - 1);
	outName[inNameLength - 1] = 0;
}



	PGPInternetAddress
CMacTCPInternetUtilities::GetLocalAddress()
{
	if (sLocalAddress.s_addr == 0) {
		GetAddrParamBlock paramBlock;
		
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.ioCRefNum = GetMacTCPDriverRef();			
		paramBlock.csCode = ipctlGetAddr;
		::PBControlSync((ParmBlkPtr) &paramBlock);
		sLocalAddress.s_addr = paramBlock.ourAddress;
	}
	
	return sLocalAddress;
}



	SInt16
CMacTCPInternetUtilities::GetMacTCPDriverRef()
{
	static SInt16	sDriverRef;
	static Boolean	sInitialized = false;
	OSStatus		err;
	
	if (! sInitialized) {
		ParamBlockRec theParamBlock;
		
		theParamBlock.ioParam.ioNamePtr = "\p.IPP";
		theParamBlock.ioParam.ioPermssn = fsCurPerm;
		
		err = ::PBOpenSync(&theParamBlock);
		if (err != noErr) {
			ThrowPGPError_(err);
		}
		sDriverRef = theParamBlock.ioParam.ioRefNum;
		sInitialized = true;
	}
	
	return sDriverRef;
}



	pascal void
CMacTCPInternetUtilities::ResultProc(
	struct hostInfo *	hostInfoPtr,
	char *				userDataPtr)
{
	(void) hostInfoPtr;
	
	(*(Boolean *) userDataPtr) = true;
}
