/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CMacTCPUDPSocket.cp,v 1.12 1999/03/10 02:34:44 heller Exp $
____________________________________________________________________________*/

#include <Devices.h>

#include "pgpMem.h"

#include "CMacTCPUDPSocket.h"


const SInt32	kReceiveBufferSize	=	16*1024;


CMacTCPUDPSocket::CMacTCPUDPSocket()
	: mCreated(false), mReceiveBuffer(nil),
	  mSending(false), mDataAvailable(false), mNotifyProcUPP(nil)
{
	mExcessReceiveHandle = ::NewHandle(0);
	if (mExcessReceiveHandle == nil) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	mNotifyProcUPP = NewUDPNotifyProc(UDPNotifyProc);
	if (mNotifyProcUPP == nil) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	mSocketType = kPGPSocketTypeDatagram;
}



CMacTCPUDPSocket::~CMacTCPUDPSocket()
{
	::DisposeHandle(mExcessReceiveHandle);
	::DisposeRoutineDescriptor(mNotifyProcUPP);
	if (mCreated) {
		UDPiopb	paramBlock;
		
		while (mSending) {
			CallIdleEventHandler();
		}
		
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.ioCRefNum = sRefNum;
		paramBlock.csCode = UDPRelease;
		paramBlock.udpStream = mStream;
		::PBControlSync((ParmBlkPtr) &paramBlock);
	}
	delete [] mReceiveBuffer;
}



	void
CMacTCPUDPSocket::Connect(
	const PGPSocketAddressInternet *	inAddress)
{
	mConnected = true;
	::BlockMoveData(inAddress, &mConnectAddress,
			sizeof(PGPSocketAddressInternet));
}



	SInt32
CMacTCPUDPSocket::Send(
	const void *	inBuffer,
	SInt32			inLength,
	SInt32			inFlags)
{
	SInt16	result = 0;
	
	(void) inFlags;
	
	if (mConnected) {
		result = SendTo(inBuffer, inLength, &mConnectAddress);
	} else {
		ThrowPGPError_(kPGPError_SocketsNotConnected);
	}
	
	return result;
}



	SInt32
CMacTCPUDPSocket::SendTo(
	const void *						inBuffer,
	SInt32								inLength,
	const PGPSocketAddressInternet *	inAddress)
{
	SInt32			toSend = inLength;
	char *			next = (char *) inBuffer;
	UDPiopb			paramBlock;
	wdsEntry		wds[2] = {	{0, 0},
								{0, 0}};
	
	CreateUDPStream((mBound) ? mBoundPort : 0);
	
	while (toSend > 0) {
		wds[0].length = (toSend > USHRT_MAX) ? USHRT_MAX : toSend;
		wds[0].ptr = next;
		toSend -= wds[0].length;
		next += wds[0].length;
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.udpStream = mStream;
		paramBlock.csParam.send.remoteHost = inAddress->sin_addr.s_addr;
		paramBlock.csParam.send.remotePort = inAddress->sin_port;
		paramBlock.csParam.send.wdsPtr = (Ptr) wds;
		mSending = true;
		try {
			ProcessCommand(UDPWrite, (IPParamBlock *) &paramBlock);
			mSending = false;
		}
		
		catch (...) {
			mSending = false;
			throw;
		}
	}
	
	return inLength;
}




	SInt32
CMacTCPUDPSocket::Receive(
	void *	outBuffer,
	SInt32	inLength,
	SInt32	inFlags)
{
	SInt32	result = 0;
	
	(void) inFlags;
	
	if (mBound) {
		result = ReceiveFrom(outBuffer, inLength, nil, nil);
	} else {
		ThrowPGPError_(kPGPError_SocketsNotBound);
	}
	
	return result;
}



	SInt32
CMacTCPUDPSocket::ReceiveFrom(
	void *						outBuffer,
	SInt32						inSize,
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	UDPiopb		paramBlock;
	Byte *		theBuffer = (Byte *) outBuffer;
	UInt16		theSize = (inSize > USHRT_MAX) ? USHRT_MAX : inSize;
	UInt16		excessReceiveHandleSize =
						::GetHandleSize(mExcessReceiveHandle);
	UInt16		amountToCopy;
	
	if (! mBound) {
		ThrowPGPError_(kPGPError_SocketsNotBound);
	}
	CreateUDPStream(mBoundPort);
	
	if (excessReceiveHandleSize > 0) {
		amountToCopy = (theSize > excessReceiveHandleSize) ?
								excessReceiveHandleSize : theSize;
										
		::BlockMoveData(	*mExcessReceiveHandle,
							theBuffer,
							amountToCopy);
		theBuffer += amountToCopy;
		theSize -= amountToCopy;
		excessReceiveHandleSize -= amountToCopy;
		::BlockMoveData(	*mExcessReceiveHandle + amountToCopy,
							*mExcessReceiveHandle,
							excessReceiveHandleSize);
		::SetHandleSize(	mExcessReceiveHandle,
							excessReceiveHandleSize);
	}
	
	if (theSize > 0) {
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.udpStream = mStream;
		ProcessCommand(UDPRead, (IPParamBlock *) &paramBlock);
		mDataAvailable = false;
		if (outAddress != nil) {
			outAddress->sin_family = kPGPAddressFamilyInternet;
			outAddress->sin_port = paramBlock.csParam.receive.remotePort;
			outAddress->sin_addr.s_addr = 
					paramBlock.csParam.receive.remoteHost;
		}
		if (ioAddressLength != nil) {
			*ioAddressLength = sizeof(PGPSocketAddressInternet);
		}
		amountToCopy = (theSize > paramBlock.csParam.receive.rcvBuffLen) ?
								paramBlock.csParam.receive.rcvBuffLen
								: theSize;
		::BlockMoveData(	paramBlock.csParam.receive.rcvBuff,
							theBuffer,
							amountToCopy);
		::SetHandleSize(	mExcessReceiveHandle,
							excessReceiveHandleSize
								+ (paramBlock.csParam.receive.rcvBuffLen
								- amountToCopy));
		if (MemError() != noErr) {
			ThrowPGPError_(kPGPError_OutOfMemory);
		}
		::BlockMoveData(	paramBlock.csParam.receive.rcvBuff + amountToCopy,
							mExcessReceiveHandle + excessReceiveHandleSize,
							paramBlock.csParam.receive.rcvBuffLen
								- amountToCopy);
		theSize -= amountToCopy;
	}
		
	return inSize - theSize;
}


	void
CMacTCPUDPSocket::Listen(
	SInt32	inMaxBacklog)
{
	(void) inMaxBacklog;
	
	ThrowPGPError_(kPGPError_SocketsOperationNotSupported);
}



	CSocket *
CMacTCPUDPSocket::Accept(
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	(void) outAddress;
	
	*ioAddressLength = 0;
	
	ThrowPGPError_(kPGPError_SocketsOperationNotSupported);
	
	return (CSocket *) kInvalidPGPSocketRef;
}



	void
CMacTCPUDPSocket::CreateUDPStream(
	SInt16	inPort)
{
	if (! mCreated) {
		UDPiopb	paramBlock;
		
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.csParam.create.rcvBuff = 
				mReceiveBuffer = new char[kReceiveBufferSize];
		if (mReceiveBuffer == nil) {
			ThrowPGPError_(kPGPError_OutOfMemory);
		}
		paramBlock.csParam.create.rcvBuffLen = kReceiveBufferSize;
		paramBlock.csParam.create.localPort = inPort;
		paramBlock.csParam.create.notifyProc = mNotifyProcUPP;
		paramBlock.csParam.create.userDataPtr = (Ptr) this;
		ProcessCommand(UDPCreate, (IPParamBlock *) &paramBlock);
		mStream = paramBlock.udpStream;
		mCreated = true;
	}
}


	Boolean
CMacTCPUDPSocket::IsReadable()
{
	return (mDataAvailable || (::GetHandleSize(mExcessReceiveHandle) > 0));
}



pascal void
CMacTCPUDPSocket::UDPNotifyProc(
	StreamPtr			inUDPStream,
	UInt16				inEventCode,
	Ptr					inUserData,
	struct ICMPReport *	inICMPMsg)
{
	(void) inUDPStream;
	(void) inICMPMsg;
	
	if (inEventCode == UDPDataArrival) {
		((CMacTCPUDPSocket *) inUserData)->mDataAvailable = true;
	}
}



	void
CMacTCPUDPSocket::GetPeerName(
	PGPSocketAddressInternet *	outName)
{
	if (mConnected) {
		*outName = mConnectAddress;
	} else {
		ThrowPGPError_(kPGPError_SocketsNotConnected);
	}
}