/*******************************************************************************
 *					C A S T 5   S Y M M E T R I C   C I P H E R
 *		Copyright (c) 1996 Northern Telecom Ltd. All rights reserved.
 *******************************************************************************
 *
 * FILE:		cast5.h
 *
 * AUTHOR(S):	R.T.Lockhart, Dept. 9C40, Nortel Ltd.
 *				C. Adams, Dept 9C21, Nortel Ltd.
 *
 * DESCRIPTION: CAST5 header file. This file defines the interface for
 * the CAST5 symmetric-key encryption/decryption/MACing code. The code
 * supports key lengths from 8 through 128 bits, in multiples of 8.
 *
 *
 * Error handling:
 * Most functions return an int that indicates the success or failure of the
 * operation. See the C5E_xxx #defines for a list of error conditions.
 *	
 * Data size assumptions: 	BYTE	- unsigned 8 bits
 *				UINT32	- unsigned 32 bits
 *
 ******************************************************************************/
 
#ifndef CAST5_H
#define CAST5_H

typedef unsigned long word32;
typedef unsigned char byte; 

void CAST5schedule( word32 xkey[32], byte const *k);
void CAST5encrypt( byte const *in, byte *out, word32 const *xkey);
void CAST5decrypt( byte const *in, byte *out, word32 const *xkey);

// stuff we've added
#ifndef CAST5_INTERLEAVED_ENCRYPT
#define CAST5_INTERLEAVED_ENCRYPT 1
#endif
#ifndef DOUBLE_DECRYPT
#define DOUBLE_DECRYPT 1
#endif

#if !CAST5_INTERLEAVED_ENCRYPT
void CAST5encryptCFB(word32 const *xkey, word32 iv0, word32 iv1,
			word32 const *src, word32 *dest, word32 len);
void CAST5decryptCFB(word32 const *xkey, word32 iv0, word32 iv1,
			word32 const *src, word32 *dest, word32 len);
#else
void CAST5encryptCFBdbl(word32 const *xkey, word32 iv0, word32 iv1,
			word32 iv2, word32 iv3, word32 const *src, word32 *dest,
			word32 len);
void CAST5decryptCFBdbl(word32 const *xkey, word32 iv0, word32 iv1,
			word32 iv2, word32 iv3, word32 const *src, word32 *dest,
			word32 len);
#endif

Boolean		VerifyCastSBoxesValid( void );

void
CAST5asm2(
	word32 const *xkey,
	word32 in0, word32 in1,
	word32 const *src,
	word32 *dest,
	word32 in2, word32 in3);

void
CAST5decryptCFB2(
	word32 const *xkey,
	word32 in0, word32 in1,	// IV
	word32 const *src,
	word32 *dest,
	word32 len);

#endif /* CAST5_H */

