/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: SleepAlert.cp,v 1.5 1999/03/10 03:03:17 heller Exp $
____________________________________________________________________________*/

#include "MacResources.h"
#include "MacFiles.h"

#include "pgpErrors.h"
#include "PGPOpenPrefs.h"
#include "SleepAlert.h"
#include "PGPDiskPreferences.h"
#include "PGPDisk.h"



	
	static OSErr
CreateAndOpenPrefsResFork( short *fileRef )
{
	OSErr	err	= noErr;
	FSSpec	spec;
	
	if( PGPGetClientPrefsFileFSSpec( &spec ) == kPGPError_NoErr )
	{
		(void) FSpDeleteResourceFork( &spec );

		FSpCreateResFile( &spec, 'pgpK', 'pref', smSystemScript );
		err	= ResError();
		
		if ( IsntErr( err ) )
		{
			*fileRef = FSpOpenResFile( &spec, fsRdWrPerm );
			err	= ResError();
		}
	}
	else
	{
		err = fnfErr;
	}

	return( err );
}


/*___________________________________________________________________________
	We do this so the driver has a known resource file where it can get an
	alert.
___________________________________________________________________________*/
	void
CopySleepAlertToPrefs( void )
{
	OSErr	err	= noErr;
	short	fileRef;
	short	saveResFile	= CurResFile();
	
	err	= CreateAndOpenPrefsResFork( &fileRef );
	if ( IsntErr( err ) )
	{
		err	= CopyResource( saveResFile, 'ALRT', kSleepRequestAlertResID,
					fileRef, 'ALRT', kSleepRequestAlertResID);
		if ( IsntErr( err ) )
		{
			err	= CopyResource( saveResFile, 'DITL', kSleepRequestAlertResID,
						fileRef, 'DITL', kSleepRequestAlertResID);
		}
		
		if ( IsntErr( err ) )
		{
			err	= CopyResource( saveResFile, 'ALRT', kSleepDemandAlertResID,
						fileRef, 'ALRT', kSleepDemandAlertResID);
			if ( IsntErr( err ) )
			{
				err	= CopyResource( saveResFile, 'DITL',
							kSleepDemandAlertResID, fileRef, 'DITL',
							kSleepDemandAlertResID);
			}
		}
		
		CloseResFile( fileRef );
		if ( IsntErr( err ) )
		{
			err	= ResError();
		}
		
		if ( IsErr( err ) )
		{
			FSSpec	spec;
			
			PGPGetClientPrefsFileFSSpec( &spec );
			FSpDeleteResourceFork( &spec );
		}
	}
	
	AssertNoErr( err, "CopySleepAlertToPrefs" );
	
	UseResFile( saveResFile );
}







