/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	Mac-specific functions to plug into the PGPMemoryMgr:
		pgpCreateStandardMemoryMgr
		pgpDisposeStandardMemoryMgrUserValue
	
	$Id: pgpMemoryMgrMac.c,v 1.4 1999/03/10 02:53:20 heller Exp $
____________________________________________________________________________*/
#include "pgpPFLErrors.h"
#include "pgpMem.h"

#include "pgpMemoryMgrPriv.h"

//#include "MacEnvirons.h"




/*____________________________________________________________________________
	The default memory allocator. Note that memory mgr will be
	NULL when allocating the memory mgr itself.
____________________________________________________________________________*/
	static void *
sMacMemoryAllocationProc(
	PGPMemoryMgrRef		mgr,
	PGPUserValue		userValue,
	PGPSize 			allocationSize,
	PGPMemoryMgrFlags	flags )
{
	(void) mgr;
	(void) flags;
	(void) userValue;

	return( OTAllocMem( allocationSize ) );
}



/*____________________________________________________________________________
	This is the default PFL memory deallocator. Note that mgr will
	be NULL when deallocating the PFLContext structure itself.
____________________________________________________________________________*/
	static PGPError
sMacMemoryDeallocationProc(
	PGPMemoryMgrRef		mgr,
	PGPUserValue		userValue,
	void *				allocation,
	PGPSize				allocationSize )
{
	(void) mgr;
	(void) allocationSize;
	(void) userValue;

	OTFreeMem( allocation );
	
	return( kPGPError_NoErr );
}



/*____________________________________________________________________________
	This is the default PFL memory reallocator. 
____________________________________________________________________________*/
	static PGPError
sMacMemoryReallocationProc(
	PGPMemoryMgrRef		mgr,
	PGPUserValue		userValue,
	void **				allocation,
	PGPSize 			newAllocationSize,
	PGPMemoryMgrFlags	flags,
	PGPSize				existingSize )
{
	PGPError	err	= kPGPError_NoErr;
	void *		newAllocation;
	
	/* we aren't required to support NULL ptr semantics */
	pgpAssert( IsntNull( *allocation ) );
	
	(void) mgr;
	(void) flags;
	(void) existingSize;
	(void) userValue;

	/* get a new pointer and copy old to it */
	newAllocation = OTReallocMem(*allocation, newAllocationSize);
	if ( IsNull( newAllocation ) )
	{
		err	= kPGPError_OutOfMemory;
	} else {
		*allocation = newAllocation;
	}
	
	return( err );
}



	static void *
sMacSecureMemoryAllocationProc(
	PGPMemoryMgrRef		mgr,
	PGPUserValue		userValue,
	PGPSize 			allocationSize,
	PGPMemoryMgrFlags	flags,
	PGPBoolean *		isNonPageable )
{
	void *		ptr	= NULL;
	
	pgpAssert( IsntNull( isNonPageable ) );
	(void) mgr;
	(void) flags;
	(void) userValue;

	*isNonPageable	= TRUE; // OT kernel memory is explicitly held
	
	return( OTAllocMem( allocationSize ) );
}




/*____________________________________________________________________________
	The default secure memory deallocator.
____________________________________________________________________________*/
	static PGPError
sMacSecureMemoryDeallocationProc(
	PGPMemoryMgrRef	mgr,
	PGPUserValue	userValue,
	void *			allocation,
	PGPSize			allocationSize,
	PGPBoolean		wasLocked )
{
	(void) mgr;
	(void) allocationSize;
	(void) userValue;
	(void) wasLocked;

	OTFreeMem( allocation );
	
	return( kPGPError_NoErr );
}



	PGPError
pgpCreateStandardMemoryMgr( PGPMemoryMgrRef *newMemoryMgr )
{
	PGPError				err	= kPGPError_NoErr;
	PGPNewMemoryMgrStruct	custom;
	
	PGPValidatePtr( newMemoryMgr );
	*newMemoryMgr	= NULL;
	
	pgpClearMemory( &custom, sizeof( custom ) );
	custom.customValue	= NULL;
	
	custom.sizeofStruct		= sizeof( custom );
	custom.allocProc		= sMacMemoryAllocationProc;
	custom.reallocProc		= sMacMemoryReallocationProc;
	custom.deallocProc		= sMacMemoryDeallocationProc;
	
	custom.secureAllocProc		= sMacSecureMemoryAllocationProc;
	custom.secureDeallocProc	= sMacSecureMemoryDeallocationProc;
	
	err	= PGPNewMemoryMgrCustom( &custom, newMemoryMgr );
	
	return( err );
}




	PGPError
pgpDisposeStandardMemoryMgrUserValue( PGPUserValue userValue )
{
	/* we don't maintain any state */
	(void)userValue;
	return( kPGPError_NoErr );
}




/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
