/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: EthernetHandler.cp,v 1.9 1999/03/17 02:05:31 jason Exp $
____________________________________________________________________________*/

#include <dlpi.h>

#include "pgpIPsecContext.h"

#include "IPHandler.h"
#include "EthernetHandler.h"


namespace {
	const PGPUInt16	kEnetHeaderLength	=	14;
	const PGPUInt16	kEnetTypeOffset		=	12;
	
	const PGPUInt16	k802HeaderLength	=	22;
	const PGPUInt16	k802MaxLength		=	1500;
	const PGPUInt16	k802TypeOffset		=	20;
	
	const PGPUInt16	kEnetTypeIP			=	0x0800;
}



	PGPBoolean
EthernetHandleReadPutDATA(
	queue_t *	inQ,
	mblk_t *	inMessage,
	SGlobals *	inGlobals)
{
	PGPBoolean	result = true;
	
	DConLogNote("  EthernetHandleReadPutDATA Begin\n");
	if (! GetPerStreamData(inQ)->rawRecv) {
		mblk_t *	header = allocb(1, 0);		// We use a 0 length header to mean no header
		
		if (header == NULL) {
			DConLogNote("  header = NULL\n");
			result = false;
		} else {
			result = IPProcessAndPutNext(true, inQ, header, inMessage, inGlobals,
						&GetPerStreamData(inQ)->inReassemblyList);
//			result = IPDecodeAndPutNext(inQ, header, inMessage, inGlobals);
			freeb(header);
		}
	} else {
		DConLogNote("  RawRecv\n");
	}

	DConLogNote("  EthernetHandleReadPutDATA End = %d\n", static_cast<int>(result));
	return result;
}



	PGPBoolean
EthernetHandleWritePutDATA(
	queue_t *	inQ,
	mblk_t *	inMessage,
	SGlobals *	inGlobals)
{
	PGPBoolean	result = true;

	DConLogNote("  EthernetHandleWritePutDATA Begin\n");
	if (pullupmsg(inMessage, kEnetHeaderLength)) {
		PGPUInt16	type = *reinterpret_cast<PGPUInt16 *>(
								inMessage->b_rptr + kEnetTypeOffset);
		PGPUInt16	headerLength = 0;
	
		if (type > k802MaxLength) {
			if (type == kEnetTypeIP) {
				DConLogNote("  Ethernet IP packet\n");
				headerLength = kEnetHeaderLength;
			}
		} else {
			if (pullupmsg(inMessage, k802HeaderLength)) {
				if (*reinterpret_cast<PGPUInt16 *>(inMessage->b_rptr + k802TypeOffset)
				 == kEnetTypeIP) {
					DConLogNote("  802 IP packet\n");
					headerLength = k802HeaderLength;
				}
			} else {
				DConLogNote("  Unable to pull up 802 header\n");
				result = false;
			}
		}
		if ((headerLength > 0) && result) {
			mblk_t *	header = dupb(inMessage);
			mblk_t *	packet = dupmsg(inMessage);
			
			if ((header == NULL) || (packet == NULL)) {
				result = false;
			} else {
				header->b_wptr = header->b_rptr + headerLength;
				packet->b_rptr += headerLength;
				result = IPProcessAndPutNext(false, inQ, header, packet, inGlobals,
							&GetPerStreamData(inQ)->outReassemblyList);
//				result = IPEncodeAndPutNext(inQ, header, packet, inGlobals);
			}
			if (header != NULL) {
				freeb(header);
			}
			if (packet != NULL) {
				freemsg(packet);
			}
		}
	} else {
		DConLogNote("  Unable to pull up ethernet header\n");
		result = false;
	}
	
	DConLogNote("  EthernetHandleWritePutDATA End = %d\n", static_cast<int>(result));
	return result;
}
