/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CHostsPanel.h,v 1.17 1999/05/05 10:35:59 wprice Exp $
____________________________________________________________________________*/
#pragma once 

#include <LListener.h>
#include <LGADialog.h>
#include <LStaticText.h>
#include <LRadioButton.h>
#include "CIconPane.h"
#include "CPanel.h"
#include "CColumnTable.h"
#include "pgpNetPrefs.h"
#include "StPGPRefs.h"

class CHostsPanel;

class	CHostsTable	:	public CColumnTable
{
public:
	enum { class_ID = 'hosT' };
						CHostsTable(LStream *inStream) :
							CColumnTable(inStream) { };
	virtual				~CHostsTable() { };
	void				FinishCreateSelf();
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
	virtual Boolean		DrawCellCustom(
								const STableCell		&inCell,
								const Rect				&inLocalRect,
								Boolean					hilite );
	void				SetPanel( CHostsPanel * panel ) { mPanel = panel;}
	PGPBoolean			FindHostSA(
								PGPUInt32			hostIndex,
								PGPUInt32 *			saIndexP );
private:
	CHostsPanel *		mPanel;
};

class	CAddHostExpertDialog	:	public LGADialog
{
public:
	enum { class_ID = 'addH' };
							CAddHostExpertDialog(LStream *inStream)
								: LGADialog(inStream) { };
	virtual					~CAddHostExpertDialog() { };
	void					FinishCreateSelf();
	virtual void			ListenToMessage(MessageT inMessage, void * ioParam);
	
	void					SetInfo(	PGPNetPrefHostEntry *entry,
										PGPBoolean			child );
	PGPBoolean				GetInfo( PGPNetPrefHostEntry *entry );
private:
	
	PGPNetPrefHostEntry 	mEntry;
	LRadioButton *			mPGPRadio,
				 *			m509Radio,
				 *			mAnyRadio;
	LStaticText	 *			mKeyCaption;
	CIconPane	 *			mKeyIcon;

	PGPKeyRef				mPGPAuthKey;
	StPGPKeySetRef			mPGPKeySet;

	PGPKeyRef				m509AuthKey;
	PGPSigRef				m509AuthCert;
	StPGPKeySetRef			m509KeySet;

	enum
	{
		edit_HostName			=	'eNam',
		edit_IPAddress			=	'eIPA',
		button_DNSLookup		=	'bDNS',
		popup_HostType			=	'pTyp',
		caption_Mask			=	'cMsk',
		edit_Mask				=	'eMsk',
		group_SharedSecret		=	'gSha',
		group_RemoteAuth		=	'gRAu',
		button_SecretPhrase		=	'bPas',
		popup_IdentityType		=	'pIde',
		edit_Identity			=	'eIde',
		radio_PGP				=	'rPGP',
		radio_X509				=	'r509',
		radio_AnyKey			=	'rAny',
		icon_Key				=	'iKey',
		caption_Key				=	'cKey'
	};
};

class CHostsPanel	:	public CPanel,
						public LListener,
						public LPeriodical,
						public LCommander
{
	friend					CHostsTable;
public:
	enum { class_ID = 'pHst' };

							CHostsPanel(LStream * inStream) : CPanel(inStream) { }
	virtual					~CHostsPanel();
					
	virtual void			ListenToMessage(MessageT inMessage, void * ioParam);
								
	virtual void			Load(void * inParam);
	virtual void			Save(void * inParam);
	
	void					AddNewHost( PGPNetPrefHostEntry *newHost );
	void					AddHostExpert( STableCell * cell,
											PGPBoolean child );
	void					UpdateStatus();
	virtual void			SpendTime( const EventRecord &inMacEvent );
	virtual Boolean			HandleKeyPress(const EventRecord&	inKeyEvent);
						
protected:
	virtual void			FinishCreateSelf();
	PGPBoolean				HostExists(
									PGPNetPrefHostEntry *	host,
									TableIndexT				exclude = 0 );
	
	CHostsTable *			mHostsTable;
	PGPNetPrefHostEntry *	mHosts;
	PGPUInt32				mNumHosts;
	PGPBoolean				mCmdButtons;
	PGPBoolean				mButtonDisconnect;
	
private:
	LPushButton *			mConnectButton;
	LPushButton *			mEditButton;
	LPushButton *			mAddButton;
	LPushButton *			mRemoveButton;
};

