/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CLogPanel.cp,v 1.22 1999/04/25 11:12:31 wprice Exp $
____________________________________________________________________________*/
#include <StandardFile.h>

#include <LPushButton.h>
#include <LBevelButton.h>
#include <OpenTptInternet.h>

#include "CString.h"
#include "MacStrings.h"
#include "CLogPanel.h"
#include "CPGPnet.h"
#include "PGPnetIPC.h"
#include "pgpMem.h"
#include "pgpKeys.h"
#include "pgpClientErrors.h"
#include "pgpIKEAlerts.h"
#include "pgpIPsecErrors.h"

namespace
{
	const PaneIDT	button_Save		=	'save';
	const PaneIDT	button_Clear	=	'cler';
	const PaneIDT	button_Name		=	1001;
	const PaneIDT	button_Protocol	=	1002;
	const PaneIDT	button_Message	=	1003;
	const PaneIDT	table_Log		=	'tLog';

	const MessageT	msg_Save		=	button_Save;
	const MessageT	msg_Clear		=	button_Clear;
	const MessageT	msg_Name		=	button_Name;
	const MessageT	msg_Protocol	=	button_Protocol;
	const MessageT	msg_Message		=	button_Message;

	enum {
		STRx_LogPanel			=	1000,
		kSaveLogAsID			=	1,
		kDefaultLogFileNameID	=	2,
		kReceivedFromStringID	=	3,
		kSentToStringID			=	4,
		
		kLogEventIndexStrIDBase	=	4,
		
		STRx_ServiceErrors		=	1005
	};
}


CLogPanel::~CLogPanel()
{
	ClearLog();
}

	void
CLogPanel::FinishCreateSelf()
{
	// Listen to buttons
	((LPushButton *) FindPaneByID(button_Save))->AddListener(this);
	((LPushButton *) FindPaneByID(button_Clear))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Name))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Protocol))->AddListener(this);
	((LBevelButton *) FindPaneByID(button_Message))->AddListener(this);
	
	mLogTable	= ( (CLogTable *)FindPaneByID( table_Log ) );
	mLogTable->SetPanel( this );
	mEvents		= NULL;
	mNumEvents	= 0;
	Load(NULL);
	CPGPnet::GetApplication()->SetLog( this );
	SetPanelTarget( mLogTable );
}

	void
CLogPanel::ClearLog()
{
	PGPError	err;
	
	if( IsntNull( mEvents ) )
	{
		err = PGPnetFreeLogData( mEvents );
		pgpAssertNoErr( err );
	}
	mEvents			= NULL;
	mNumEvents		= 0;
}

	void
CLogPanel::Load( void * )
{
	PGPnetLogRef	logRef;
	PGPError		err;
	PGPUInt32		eventIndex;
	
	ClearLog();
	err = PGPnetOpenLog( CPGPnet::GetMemMgr(), FALSE, &logRef );
	if( IsntPGPError( err ) )
	{
		err = PGPnetReadLogData( logRef, &mNumEvents, &mEvents );
		pgpAssertNoErr( err );
		err = PGPnetCloseLogFile( logRef );
		pgpAssertNoErr( err );
		for( eventIndex = 0; eventIndex < mNumEvents; eventIndex++ )
		{
			mLogTable->InsertSiblingRows( 1, LArray::index_Last,
						&eventIndex, sizeof( PGPUInt32 ), FALSE, TRUE );
		}
	}
#if PGP_DEBUG
	/*PGPnetLogEvent *	testEvent;
	
	testEvent = (PGPnetLogEvent *)PGPNewData( CPGPnet::GetMemMgr(),
										sizeof(PGPnetLogEvent), 0 );
	testEvent->timeOfEvent = PGPGetTime();
	testEvent->typeOfEvent = kPGPnetLogEvent_PGPError;
	testEvent->info.pgperror.error = kPGPError_UserAbort;
	
	AddEvent( testEvent );*/
#endif
}

	void
CLogPanel::AddEvent(
	PGPnetLogEvent *	event )
{
	PGPError			err;
	PGPUInt32			logIndex;
	STableCell			cell;
	
	if( IsntNull( event ) )
	{
		if( mNumEvents < kPGPnetLogMaxNumberOfEvents - 1 )
			mNumEvents ++;
		else
		{
			TableIndexT		rows,
							cols;
			UInt32			dataSize = sizeof(PGPUInt32);
			
			cell.col = 1;
			mLogTable->RemoveRows( 1, 1, TRUE );
			mLogTable->GetWideOpenTableSize( rows, cols );
			for( cell.row = 1; cell.row <= rows; cell.row++ )
			{
				mLogTable->GetCellData( cell, &logIndex, dataSize );
				logIndex -= 1;
				mLogTable->SetCellData( cell, &logIndex, dataSize );
			}
			pgpCopyMemory( &mEvents[1], &mEvents[0],
				mNumEvents * sizeof(PGPnetLogEvent) );
		}
		err = PGPReallocData( CPGPnet::GetMemMgr(), &mEvents,
					mNumEvents * sizeof( PGPnetLogEvent ), 0 );
		if( IsntPGPError( err ) )
		{
			logIndex = mNumEvents - 1;
			pgpCopyMemory( event, &mEvents[logIndex],
							sizeof( PGPnetLogEvent ) );
			cell.col = 1;
			cell.row = mLogTable->InsertSiblingRows( 1, LArray::index_Last,
							&logIndex, sizeof( PGPUInt32 ), FALSE, TRUE );
			mLogTable->ScrollCellIntoFrame( cell );
		}
		PGPFreeData( event );
	}
}

	void
CLogPanel::ListenToMessage(
	MessageT	inMessage,
	void *		ioParam)
{
	(void) ioParam;
	
	switch (inMessage)
	{
		case msg_Name:
		case msg_Protocol:
		case msg_Message:
		{
			break;
		}
		case msg_Clear:
		{
			STableCell cell;
			
			cell.col = cell.row = 1;
			mLogTable->RemoveAllRows( TRUE );
			mLogTable->ScrollCellIntoFrame( cell );
			ClearLog();
			CPGPnet::PostPNEvent( kPGPnetHLEvent_ClearLog );
			break;
		}
		case msg_Save:
		{
			StandardFileReply	reply;
			
			// Choose where to save the copy
			::StandardPutFile(	CString(CStringFromSTRx(STRx_LogPanel, kSaveLogAsID)),
								CString(CStringFromSTRx(STRx_LogPanel, kDefaultLogFileNameID)),
								&reply);
			if (reply.sfGood)
			{
			}
			break;
		}
	};
}

	void
CLogTable::FinishCreateSelf()
{
	CColumnTable::FinishCreateSelf();
}

	Boolean
CLogTable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&indentLevel,
	Str255				data,
	StyleParameter		&style )
{
	PGPUInt32			logIndex;
	TableIndexT			col;
	Uint32				dataSize = sizeof(PGPUInt32);
	PGPnetLogEvent *	events = mPanel->mEvents;
	char				cstr[256];
	Str255				pstr;
	
	iconID;	indentLevel;	style;
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &logIndex, dataSize );
	switch( col )
	{
		case 1:
		{
			PGPUInt32	td;
			
			td = PGPTimeToMacTime( events[logIndex].timeOfEvent );
			IUDateString( td, shortDate, data );
			AppendPString( "\p ", data );
			IUTimeString( td, TRUE, pstr );
			AppendPString( pstr, data );
			break;
		}
		case 2:
			GetIndString( data, STRx_LogPanel,
							kLogEventIndexStrIDBase +
							events[logIndex].typeOfEvent );
			break;
		case 3:
			if( events[logIndex].ipaddress )
			{
				OTInetHostToString( events[logIndex].ipaddress, cstr );
				CToPString( cstr, data );
			}
			break;
		case 4:
			switch( events[logIndex].typeOfEvent )
			{
				case kPGPnetLogEvent_DebugText:
					break;
				case kPGPnetLogEvent_IPSEC:
					PGPGetIPsecErrorString( 
						events[logIndex].info.ipsec.error,
						sizeof(cstr), cstr );
					CToPString( cstr, data );
					break;
				case kPGPnetLogEvent_PGPError:
				{
					PGPGetClientErrorString(
							events[logIndex].info.pgperror.error,
							sizeof(cstr), cstr );
					CToPString( cstr, data );
					break;
				}
				case kPGPnetLogEvent_PGPike:
					if( events[logIndex].info.ikealert.alert ==
						kPGPike_AL_None )
					{
						PGPGetIkeInternalAlertString( (PGPikeInternalAlert)
								events[logIndex].info.ikealert.value,
								sizeof(cstr), cstr );
						CToPString( cstr, data );
					}
					else
					{
						PGPGetIkeAlertString(
								events[logIndex].info.ikealert.alert,
								sizeof(cstr), cstr );
						CToPString( cstr, data );
						if( events[logIndex].info.ikealert.remoteGenerated )
							GetIndString( pstr, STRx_LogPanel,
											kReceivedFromStringID );
						else
							GetIndString( pstr, STRx_LogPanel,
											kSentToStringID );
						AppendPString( pstr, data );
					}
					break;
				case kPGPnetLogEvent_System:
					break;
				case kPGPnetLogEvent_Service:
					GetIndString( data, STRx_ServiceErrors,
						events[logIndex].info.svcerror.error );
					if( events[logIndex].info.svcerror.error ==
						kPGPnetSrvcError_AuthenticatedKey )
					{
						char keyIDString[kPGPMaxKeyIDStringSize];
						
						if( IsntPGPError( PGPGetKeyIDString(
								&events[logIndex].info.svcerror.keyID,
								kPGPKeyIDString_Abbreviated, keyIDString ) ) )
						{
							CToPString( keyIDString, pstr );
							AppendPString( pstr, data );
						}
					}
					break;
			}
			break;
	}
	return FALSE;
}

