/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPGPnet.cp,v 1.40 1999/05/23 16:51:31 heller Exp $
____________________________________________________________________________*/
#include <Appearance.h>
#include <OpenTransport.h>

#include "CPGPnet.h"

#include <LActiveScroller.h>
#include <LAMControlImp.h>
#include <LAMPushButtonImp.h>
#include <LAMPopupGroupBoxImp.h>
#include <LAMStaticTextImp.h>
#include <LAMTrackActionImp.h>
#include <LBevelButton.h>
#include <LCaption.h>
#include <LChasingArrows.h>
#include <LCheckBox.h>
#include <LCheckBoxGroupBox.h>
#include <LGADialog.h>
#include <LEditText.h>
#include <LGrowZone.h>
#include <LLittleArrows.h>
#include <LMenu.h>
#include <LMenuBar.h>
#include <LMultiPanelView.h>
#include <LPopupButton.h>
#include <LPopupGroupBox.h>
#include <LPushButton.h>
#include <LRadioButton.h>
#include <LRadioGroupView.h>
#include <LScrollerView.h>
#include <LStaticText.h>
#include <LScrollBar.h>
#include <LTabsControl.h>
#include <LTabGroup.h>
#include <LTextGroupBox.h>
#include <PP_Messages.h>
#include <PP_Resources.h>
#include <UControlRegistry.h>
#include <UDesktop.h>
#include <UDrawingState.h>
#include <UEnvironment.h>
#include <UGraphicUtils.h>
#include <UMemoryMgr.h>
#include <UModalDialogs.h>
#include <URegistrar.h>

#include "pgpUtilities.h"
#include "pgpSDKPrefs.h"
#include "pgpKeys.h"
#include "pgpLeaks.h"
#include "pgpMem.h"
#include "PowerPlantLeaks.h"
#include "MacInternet.h"
#include "MacStrings.h"
#include "WarningAlert.h"
#include "pgpClientErrors.h"
#include "pgpClientLib.h"
#include "CPGPStDialogHandler.h"
#include "CGADurationEditField.h"
#include "pflPrefTypes.h"

#include "CPGPActiveScroller.h"
#include "CPGPAMTabsControlImp.h"
#include "CPGPAMEditTextImp.h"

#include "CIconPane.h"
#include "CPicture.h"
#include "CString.h"
#include "CVersionCaption.h"

#include "CPGPnetWindow.h"
#include "CStatusPanel.h"
#include "CLogPanel.h"
#include "CHostsPanel.h"
#include "CGeneralPanel.h"
#include "CAuthenticationPanel.h"
#include "CAdvancedPanel.h"
#include "COTConfigDialog.h"
#include "PGPnetOpenPrefs.h"
#include "PGPnetIPC.h"


namespace {
	const ResIDT	ppob_PGPnetAboutWindow		=	128;
	const ResIDT	ppob_PGPnetWindow			=	1000;

	const ResIDT	ppob_OptionsDialog			=	2000;
	const ResIDT	ppob_GeneralPanel			=	2001;
	const ResIDT	ppob_AuthenticationPanel	=	2002;
	const ResIDT	ppob_AdvancedPanel			=	2003;
	
	const ResIDT	ppob_ConfigDialog			=	3500;

	enum {
		STRx_PGPnet		=	1003,
		kErrorStringID	=	1,
		kPGPWebSiteURLStrIndex,
		kCantLaunchWebBrowserBecauseStrIndex,
		kAboutCreditsButtonTitleStrIndex,
		kAboutInfoButtonTitleStrIndex,
		kNoServiceStrIndex,
		kBadConfigStrIndex,
		kPGPPassphrasePromptStrIndex,
		k509PassphrasePromptStrIndex
	};



	enum {
		panel_First				=	1,
		panel_General			=	panel_First,
		panel_Authentication,
		panel_Advanced
	};

	const PaneIDT	multi_Panels			=	1002;
	
	const CommandT	cmd_ViewStatus			=	'mVSt';
	const CommandT	cmd_ViewLog				=	'mVLo';
	const CommandT	cmd_ViewHosts			=	'mVHo';
	const CommandT	cmd_Configurations		=	'mCfg';
	
#if PGP_DEBUG
	const ResIDT	ppob_IKELogWindow		=	10000;
	const CommandT	cmd_IKELog				=	'ikeL';
	const PaneIDT	textedit_IKELog			=	'txIK';
#endif
}


CPGPnet *		CPGPnet::sApplication		=	nil;
PGPContextRef	CPGPnet::sPGPContext		=	kInvalidPGPContextRef;
PGPKeySetRef	CPGPnet::sDefaultKeyrings	=	kInvalidPGPKeySetRef;
PGPPrefRef		CPGPnet::sNetPrefs			=	kInvalidPGPPrefRef;
PGPMemoryMgrRef	CPGPnet::sMemoryMgr			=	kInvalidPGPMemoryMgrRef;
PGPBoolean		CPGPnet::sHasPGPAuth		=	FALSE;
PGPBoolean		CPGPnet::sHasX509Auth		=	FALSE;


CPGPnetStDialogHandler::CPGPnetStDialogHandler(
	ResIDT		inDialogResID,			// 'PPob' and 'RidL' Resource ID
	LCommander	*inSuper)
		: CPGPStDialogHandler( inDialogResID, inSuper )
{
}

CPGPnetStDialogHandler::~CPGPnetStDialogHandler(void)
{
}

	void
CPGPnetStDialogHandler::EventHighLevel(
	const EventRecord&	inMacEvent)
{
	CPGPnet::GetApplication()->EventHighLevel( inMacEvent );
}

	int
main(void)
{
#if PGP_DEBUG
	SetDebugThrow_( debugAction_LowLevelDebugger );
	SetDebugSignal_( debugAction_LowLevelDebugger );
#else
	SetDebugThrow_( debugAction_Nothing );
	SetDebugSignal_( debugAction_Nothing );
#endif

	InitializeHeap(3);
	UQDGlobals::InitializeToolbox(&qd);
	UEnvironment::InitEnvironment();
	
	if( PGPClientVerifyEnvironment() )
	{
		new LGrowZone(20000);
		
	#if USE_MAC_DEBUG_LEAKS
		{ CForceInitLPeriodical	temp; }
	#endif
		InitOpenTransport();

		pgpLeaksBeginSession("PGPnet app");
		{
			CPGPnet	theApp;
			theApp.Run();
		}
		pgpLeaksEndSession();
		
		CloseOpenTransport();
	}
		
	return 0;
}

CPGPnet::CPGPnet()
{
	::RegisterAppearanceClient();

// Need to suspend first call to URegistrar to avoid a powerplant leak
MacLeaks_Suspend();
	RegisterClass_(CPGPnetWindow);
MacLeaks_Resume();
	RegisterClass_(CStatusPanel);
	RegisterClass_(CLogPanel);
	RegisterClass_(CHostsPanel);
	RegisterClass_(CHostsTable);
	RegisterClass_(CLogTable);
	RegisterClass_(CStatusTable);
	RegisterClass_(CIKETable);
	RegisterClass_(CIPSECTable);
	
	RegisterClass_(CGeneralPanel);
	RegisterClass_(CAuthenticationPanel);
	RegisterClass_(CAdvancedPanel);
	RegisterClass_(CGADurationEditField);
	RegisterClass_(COTConfigDialog);

	RegisterClass_(CPGPActiveScroller);
	RegisterClass_(CIconPane);
	RegisterClass_(CPicture);
	RegisterClass_(CVersionCaption);

	RegisterClass_(LAttachment);
	RegisterClass_(LActiveScroller);
	RegisterClass_(LCaption);
	RegisterClass_(LChasingArrows);
	RegisterClass_(LCheckBoxGroupBox);
	RegisterClass_(LPushButton);
	RegisterClass_(LTabsControl);
	RegisterClass_(LMultiPanelView);
	RegisterClass_(LGADialog);
	RegisterClass_(LTextGroupBox);
	RegisterClass_(LPopupButton);
	RegisterClass_(LPopupGroupBox);
	RegisterClass_(LRadioButton);
	RegisterClass_(LEditText);
	RegisterClass_(LCheckBox);
	RegisterClass_(LRadioGroupView);
	RegisterClass_(LBevelButton);
	RegisterClass_(LScrollBar);
	RegisterClass_(LScrollerView);
	RegisterClass_(LStaticText);
	RegisterClass_(LLittleArrows);
	RegisterClass_(LTabGroup);
	RegisterClass_(LTextEditView);
	RegisterClass_(LWindow);
	RegisterClass_(LWindowThemeAttachment);
	
	RegisterClassID_(CPGPAMEditTextImp,		LEditText::imp_class_ID);
	RegisterClassID_(CPGPAMTabsControlImp,	LTabsControl::imp_class_ID);

	RegisterClassID_(LAMControlImp, 		LChasingArrows::imp_class_ID );
	RegisterClassID_(LAMPushButtonImp,		LPushButton::imp_class_ID);
	RegisterClassID_(LAMPopupButtonImp, 	LPopupButton::imp_class_ID);
	RegisterClassID_(LAMPopupGroupBoxImp,	LPopupGroupBox::imp_class_ID);
	RegisterClassID_(LAMStaticTextImp,		LStaticText::imp_class_ID);
	RegisterClassID_(LAMControlImp,			LCheckBoxGroupBox::imp_class_ID);
	RegisterClassID_(LAMControlImp, 		LBevelButton::imp_class_ID);
	RegisterClassID_(LAMControlImp, 		LTextGroupBox::imp_class_ID);
	RegisterClassID_(LAMControlImp, 		LRadioButton::imp_class_ID);
	RegisterClassID_(LAMControlImp, 		LCheckBox::imp_class_ID);
	RegisterClassID_(LAMTrackActionImp, 	LLittleArrows::imp_class_ID );
	RegisterClassID_(LAMControlImp,			LScrollBar::imp_class_ID);
	
	sApplication	= this;
	mFinished		= FALSE;
	
	PGPError	pgpErr;
	
	pgpErr = PGPsdkInit();
	PGPThrowIfPGPError_(pgpErr);
	pgpErr = PGPNewContext( kPGPsdkAPIVersion, &sPGPContext );
	if( IsntPGPError( pgpErr ) )
		PGPsdkLoadDefaultPrefs( sPGPContext );
	if( IsntPGPError( pgpErr ) )
		pgpErr = PGPNewMemoryMgr( 0, &sMemoryMgr);
	if( IsntPGPError( pgpErr ) )
		pgpErr = PGPnetOpenPrefs( sMemoryMgr, &sNetPrefs );
	if( IsntPGPError( pgpErr ) )
		pgpErr = PGPOpenDefaultKeyRings( sPGPContext, 0, &sDefaultKeyrings );
	mWindow = NULL;
#if PGP_DEBUG
	mIKEWindow = NULL;
#endif
	if( IsPGPError( pgpErr ) )
	{
		WarningAlert(	kWAStopAlertType,
						kWAOKStyle,
						STRx_PGPnet,
						kBadConfigStrIndex );
		if( PGPPrefRefIsValid( sNetPrefs ) )
			PGPClosePrefFile( sNetPrefs );
		if (PGPMemoryMgrRefIsValid(sMemoryMgr))
			PGPFreeMemoryMgr( sMemoryMgr );
		if ( PGPContextRefIsValid( sPGPContext ) )
			PGPFreeContext( sPGPContext );
		PGPsdkCleanup();
		ExitToShell();
	}
}

CPGPnet::~CPGPnet()
{
	PostPNEvent( kPGPnetHLEvent_AppShutdown );
	if( IsntNull( mWindow ) )
		delete mWindow;
#if PGP_DEBUG
	if( IsntNull( mIKEWindow ) )
		delete mIKEWindow;
#endif
	if( PGPKeySetRefIsValid(sDefaultKeyrings) )
		PGPFreeKeySet( sDefaultKeyrings );
	if( PGPPrefRefIsValid( sNetPrefs ) )
	{
		PGPSavePrefFile( sNetPrefs );
		PGPClosePrefFile( sNetPrefs );
	}
	if (PGPMemoryMgrRefIsValid(sMemoryMgr))
		PGPFreeMemoryMgr( sMemoryMgr );
	if ( PGPContextRefIsValid( sPGPContext ) )
		PGPFreeContext( sPGPContext );
	PGPsdkCleanup();
}

	void
CPGPnet::StartUp()
{
	PGPBoolean	first;
	PGPError	err;
	
#if PGP_DEBUG
	InstallDebugMenu();
	mIKEWindow = LWindow::CreateWindow( ppob_IKELogWindow, this );
	if( IsntNull( mIKEWindow ) )
	{
		mIKEView = (LTextEditView *)mIKEWindow->FindPaneByID( textedit_IKELog );
	}
#endif
	PostPNEvent( kPGPnetHLEvent_AppStartup );
	CheckAuthKeys();
	mWindow = (CPGPnetWindow *)LWindow::CreateWindow( ppob_PGPnetWindow, this );
	err = PGPGetPrefBoolean( sNetPrefs, kPGPNetPrefFirstExecution, &first );
	if( IsntPGPError( err ) && first )
	{
		ProcessCommand( cmd_ViewHosts );
		ProcessCommand( cmd_Configurations );
		err = PGPSetPrefBoolean( sNetPrefs, kPGPNetPrefFirstExecution, FALSE );
		if( IsntPGPError( err ) )
		{
			err = PGPSavePrefFile( sNetPrefs );
			pgpAssertNoErr( err );
		}
	}
	mWindow->Show();
	StartIdling();
}

	void
CPGPnet::SpendTime(
	const EventRecord & )
{
	if( mFinished )
	{
		ProcessCommand( cmd_Quit, NULL );
	}
}

	Boolean
CPGPnet::ObeyCommand(
	CommandT	inCommand,
	void *		ioParam)
{
	Boolean		cmdHandled = true;
	PGPError	err;
	MessageT	theMessage;

	switch (inCommand)
	{
		case cmd_ViewStatus:
			mWindow->ShowPanel( 1 );
			break;
		case cmd_ViewLog:
			mWindow->ShowPanel( 2 );
			break;
		case cmd_ViewHosts:
			mWindow->ShowPanel( 3 );
			break;
		case cmd_Configurations:
		{
			CPGPnetStDialogHandler	theDialog(ppob_ConfigDialog, this);
			
			do
			{
				theMessage = theDialog.DoDialog();
			} while (theMessage != msg_OK);
			break;
		}
		case cmd_Preferences:
		{
			CPGPnetStDialogHandler	theDialog(ppob_OptionsDialog, this);
			LMultiPanelView *		multiPanel = (LMultiPanelView *)
										theDialog.GetDialog()->
										FindPaneByID(multi_Panels);
			
			// Add panels to dialog
			multiPanel->AddPanel(	ppob_GeneralPanel,
									nil,
									panel_General);
			multiPanel->AddPanel(	ppob_AuthenticationPanel,
									nil,
									panel_Authentication);
			multiPanel->AddPanel(	ppob_AdvancedPanel,
									nil,
									panel_Advanced);
			multiPanel->CreateAllPanels();
			multiPanel->SwitchToPanel(panel_First);
			
			// Do the dialog
			do
			{
				try {
					theMessage = theDialog.DoDialog();
				}
				catch (CPGPException & error) {
					ShowError(error);
				}
				catch (...) {
					ShowError(CPGPException(kPGPError_UnknownError));
				}
				
				switch (theMessage)
				{
					case msg_OK:
						UInt16	numPanels = multiPanel->GetPanelCount();
						
						for (UInt16 i = 1; i <= numPanels; i++)
							( (CPanel *)multiPanel->GetPanel( i ) )->Save( NULL );
						err = PGPSavePrefFile( sNetPrefs );
						pgpAssertNoErr( err );
						CheckAuthKeys();
						PostPNEvent( kPGPnetHLEvent_UpdateConfig );
						break;
				}
			} while ((theMessage != msg_OK) && (theMessage != msg_Cancel));
			break;
		}
#if PGP_DEBUG
		case cmd_IKELog:
			mIKEWindow->Show();
			mIKEWindow->Select();
			break;
#endif
		default:
			cmdHandled = LApplication::ObeyCommand(inCommand, ioParam);
			break;
	}
	
	return cmdHandled;
}

	void
CPGPnet::CheckAuthKeys()
{
	PGPKeyID *	keyID;
	PGPSize		len = 0;
	
	sHasPGPAuth = sHasX509Auth = FALSE;
	PGPGetPrefData( sNetPrefs, kPGPNetPrefPGPAuthKeyID, &len, &keyID );
	if( IsntNull( keyID ) )
	{
		sHasPGPAuth = TRUE;
		PGPFreeData( keyID );
	}
	PGPGetPrefData( sNetPrefs, kPGPNetPrefX509AuthKeyID, &len, &keyID );
	if( IsntNull( keyID ) )
	{
		sHasX509Auth = TRUE;
		PGPFreeData( keyID );
	}
}

	void
CPGPnet::FindCommandStatus(
	CommandT	inCommand,
	Boolean &	outEnabled,
	Boolean &	outUsesMark,
	Char16 &	outMark,
	Str255		outName)
{

	switch (inCommand)
	{
		case cmd_Preferences:
		case cmd_ViewStatus:
		case cmd_ViewLog:
		case cmd_ViewHosts:
		case cmd_Configurations:
#if PGP_DEBUG
		case cmd_IKELog:
#endif
			outEnabled = true;
			break;
		default:
			LApplication::FindCommandStatus(inCommand, outEnabled,
												outUsesMark, outMark, outName);
			break;
	}
}

	void
CPGPnet::PostPNEvent(
	UInt32			eventID,
	void *			data,
	PGPUInt32		dataLen )
{
	EventRecord			event;
	PGPUInt32			rcvr;
	OSErr				err;
	
	pgpClearMemory( &event, sizeof( EventRecord ) );
	event.what			= kHighLevelEvent;
	event.message		= kPGPnetHLEventClass;
	event.where.v		= eventID >> 16;
	event.where.h		= eventID & 0xFFFF;
	rcvr				= kPGPnetServiceID;
	
	err = PostHighLevelEvent( &event, (void *)rcvr, 0, data, dataLen,
			receiverIDisSignature + nReturnReceipt );
	if( IsErr( err ) &&
		( eventID != kPGPnetHLEvent_AppShutdown ) )
	{
#if PGP_DEBUG
		SysBeep( 1 );
#else
		WarningAlert(	kWAStopAlertType,
						kWAOKStyle,
						STRx_PGPnet,
						kNoServiceStrIndex );
		CPGPnet::GetApplication()->ProcessCommand( cmd_Quit, NULL );
#endif
	}
}

	PGPKeyRef
CPGPnet::GetLocalPGPAuthKey()
{
	PGPKeyRef	key = kInvalidPGPKeyRef;
	PGPKeyID *	keyID;
	PGPSize		len;
	PGPUInt32	algNum;
	PGPBoolean	canSign;
	
	PGPGetPrefData( sNetPrefs, kPGPNetPrefPGPAuthKeyID, &len, &keyID );
	if( IsntNull( keyID ) )
	{
		PGPGetPrefNumber( sNetPrefs, kPGPNetPrefPGPAuthKeyAlgorithm, &algNum );
		PGPGetKeyByKeyID( sDefaultKeyrings, keyID,
			(PGPPublicKeyAlgorithm)algNum, &key );
		PGPGetKeyBoolean( key, kPGPKeyPropCanSign, &canSign );
		if( !canSign )
			key = kInvalidPGPKeyRef;
		PGPFreeData( keyID );
	}
	return key;
}

	PGPKeyRef
CPGPnet::GetLocalX509AuthKey(
	PGPSigRef *			pCert )
{
	PGPError			err = kPGPError_NoErr;
	PGPKeyRef			key = kInvalidPGPKeyRef;
	PGPKeyID *			keyID;
	PGPSize				len;
	PGPUInt32			algNum;
	PGPBoolean			canSign;
	PGPSize				iasnSize = 0;
	PGPByte *			iasn = NULL;
	PGPSigRef			cert;
					
	*pCert = kInvalidPGPSigRef;
	
	PGPGetPrefData( sNetPrefs, kPGPNetPrefX509AuthKeyID, &len, &keyID );
	if( IsntNull( keyID ) )
	{
		PGPGetPrefNumber( sNetPrefs, kPGPNetPrefX509AuthKeyAlgorithm,
			&algNum );
		PGPGetPrefData( sNetPrefs, kPGPNetPrefX509AuthCertIASN,
			&iasnSize, &iasn );
		if( IsntNull( iasn ) )
		{
			err = PGPX509CertFromExport( sPGPContext,
						algNum, (PGPByte *)keyID, iasn, iasnSize,
						sDefaultKeyrings, &key, &cert );
			if( IsntPGPError( err ) )
			{
				PGPGetKeyBoolean( key, kPGPKeyPropCanSign, &canSign );
				if( !canSign )
					key = kInvalidPGPKeyRef;
				else
					*pCert	= cert;
			}
			PGPFreeData( iasn );
		}
		PGPFreeData( keyID );
	}
	return key;
}

	void
CPGPnet::EventHighLevel(
	const EventRecord&	inMacEvent)
{
	UInt32				msgType;
	
	msgType = (unsigned long)inMacEvent.where.v << 16;
	msgType |= inMacEvent.where.h;
	switch( inMacEvent.message )
	{
		case kPGPnetHLEventClass:
		{
			OSErr			err;
			PGPError		pgpErr;
			TargetID		source;
			UInt32			refCon;
			UInt32			length = 0;
			char *			buff = NULL;
			char			*outputPassphrase;
			PGPKeyRef		key;
			PGPSigRef		cert;
			Str255			str;
			char			cstr[256];
			
			err = AcceptHighLevelEvent( &source, &refCon, NULL, &length );
			if( err == bufferIsSmall )
			{
				buff = (char *)PGPNewData( sMemoryMgr, length, 0 );
				if( IsntNull( buff ) )
				{
					err = AcceptHighLevelEvent( &source, &refCon, buff, &length );
					pgpAssertNoErr( err );
				}
			}
			if( IsntErr( err ) )
			{
				switch( msgType )
				{
					case kPGPnetHLEvent_LogEvent:
						if( IsntNull( mLogPanel ) )
							mLogPanel->AddEvent( (PGPnetLogEvent *)buff );
						break;
					case kPGPnetHLEvent_NewHost:
						if( IsntNull( mHostsPanel ) )
							mHostsPanel->AddNewHost( (PGPNetPrefHostEntry *)buff );
						break;
					case kPGPnetHLEvent_NeedPhrasePGPQ:
						mFinished = TRUE;
					case kPGPnetHLEvent_NeedPhrasePGP:
						key = GetLocalPGPAuthKey();
						if( PGPKeyRefIsValid( key ) )
						{
							GetIndString( str, STRx_PGPnet, kPGPPassphrasePromptStrIndex );
							PToCString( str, cstr );
							UDesktop::Deactivate();
							
							pgpErr = PGPKeyPassphraseDialog( sPGPContext, key,
										PGPOUIDialogPrompt( sPGPContext, cstr ),
										PGPOUIOutputPassphrase( sPGPContext,
											&outputPassphrase ),
										PGPOLastOption( sPGPContext ) );
							
							UDesktop::Activate();
							if( IsntPGPError( pgpErr ) &&
								IsntNull( outputPassphrase ) )
							{
								PostPNEvent( kPGPnetHLEvent_PhrasePGP,
									outputPassphrase,
									strlen( outputPassphrase ) + 1 );
								PGPFreeData( outputPassphrase );
							}
						}
						break;
					case kPGPnetHLEvent_NeedPhraseX509Q:
						mFinished = TRUE;
					case kPGPnetHLEvent_NeedPhraseX509:
						key = GetLocalX509AuthKey( &cert );
						if( PGPKeyRefIsValid( key ) )
						{
							GetIndString( str, STRx_PGPnet, kPGPPassphrasePromptStrIndex );
							PToCString( str, cstr );
							UDesktop::Deactivate();
							
							pgpErr = PGPKeyPassphraseDialog( sPGPContext, key,
										PGPOUIDialogPrompt( sPGPContext, cstr ),
										PGPOUIOutputPassphrase( sPGPContext,
											&outputPassphrase ),
										PGPOLastOption( sPGPContext ) );
							
							UDesktop::Activate();
							if( IsntPGPError( pgpErr ) &&
								IsntNull( outputPassphrase ) )
							{
								PostPNEvent( kPGPnetHLEvent_Phrase509,
									outputPassphrase,
									strlen( outputPassphrase ) + 1 );
								PGPFreeData( outputPassphrase );
							}
						}
						break;
					case kPGPnetHLEvent_KeyringUpdate:
						if( PGPKeySetRefIsValid(sDefaultKeyrings) )
							PGPFreeKeySet( sDefaultKeyrings );
						sDefaultKeyrings = kInvalidPGPKeySetRef;
						pgpErr = PGPOpenDefaultKeyRings( sPGPContext, 0,
							&sDefaultKeyrings );
						break;
					case kPGPnetHLEvent_StatusFull:
						if( IsntNull( mStatusPanel ) )
							mStatusPanel->SetFull( (PGPikeSA *)buff,
													length / sizeof(PGPikeSA) );
						break;
					case kPGPnetHLEvent_UpdateSA:
						if( IsntNull( mStatusPanel ) )
							mStatusPanel->UpdateSingle( (PGPikeSA *)buff );
						if( IsntNull( mHostsPanel ) )
							mHostsPanel->UpdateStatus();
						break;
					case kPGPnetHLEvent_RemoveSA:
						if( IsntNull( mStatusPanel ) )
							mStatusPanel->RemoveSingle( (PGPikeSA *)buff );
						if( IsntNull( mHostsPanel ) )
							mHostsPanel->UpdateStatus();
						break;
#if PGP_DEBUG
					case kPGPnetHLEvent_IKELog:
						if( IsntNull( buff ) && IsntNull( mIKEView ) )
						{
							if( mIKEView->FocusDraw() )
							{
								TEHandle	teh = mIKEView->GetMacTEH();
								char *		p;
								
								if( (*teh)->teLength > 31000 )
								{
									TESetSelect( 0, 0x7FFF, teh );
									TEDelete( teh );
									TESetSelect( (*teh)->teLength, (*teh)->teLength, teh );
								}
								for( p = buff; *p; p++ )
									if( *p == '\n' )
										*p = '\r';
								mIKEView->Insert( buff, length, nil, true );
							}
						}
						// FALL THROUGH
#endif
					default:
						if( IsntNull( buff ) )
							PGPFreeData( buff );
						break;
				}
			}
			break;
		}
		case HighLevelEventMsgClass:
			if( msgType == rtrnReceiptMsgID )
			{
				if( inMacEvent.modifiers != msgWasFullyAccepted )
				{
					WarningAlert(	kWAStopAlertType,
									kWAOKStyle,
									STRx_PGPnet,
									kNoServiceStrIndex );
					ProcessCommand( cmd_Quit, NULL );
				}
			}
			break;
		default:
			LApplication::EventHighLevel( inMacEvent );
	}
}

	void
CPGPnet::ShowAboutBox()
{
	Boolean	didShowDialog = FALSE;
	FSSpec	libraryFileSpec;
	
	// Open the library resource file at the top of the resource chain
	// so we get our pictures.
	if( IsntErr( PGPGetClientLibFSSpec( &libraryFileSpec ) ) )
	{
		short	saveResFile;
		short	libFileRefNum;
		
		saveResFile = CurResFile();
		
		libFileRefNum = FSpOpenResFile( &libraryFileSpec, fsRdPerm );
		if( libFileRefNum > 0 )
		{
			UseResFile( libFileRefNum );
			
			{
				CPGPnetStDialogHandler	aboutDialog(ppob_PGPnetAboutWindow, this);
				LWindow					*theDialog;
				MessageT				message;
				Boolean					credits = FALSE;
				Str255					str;
				
				const MessageT		kPGPButtonMessage		= 'bPGP';
				const MessageT		kCreditsButtonMessage	= 'bCre';
				const MessageT		kOKButtonMessage		= 'bOK ';
				
				const PaneIDT		kCreditsButtonPaneID	= 'bCre';
				const PaneIDT		kAboutPicturePaneID		= 'APIC';
				const PaneIDT		kCreditsPicturePaneID	= 'CPIC';
				const PaneIDT		kBSAFEPicturePaneID		= 'RPIC';
				const PaneIDT		kLicenseCaptionID		= 'cLic';
				
				theDialog = aboutDialog.GetDialog();
				didShowDialog = TRUE;

				PGPMakeLicenseStr( sPGPContext, str );
				((LStaticText *)theDialog->FindPaneByID(kLicenseCaptionID))->
					SetDescriptor(str);
				
				while((message = aboutDialog.DoDialog()) != kOKButtonMessage )
				{
					if( message == kPGPButtonMessage )
					{
						Str255		url;
						OSStatus	status;
						
						GetIndString( url, STRx_PGPnet,
										kPGPWebSiteURLStrIndex );
						
						status = OpenURL( url, 'PGPn' );
						if( IsErr( status ) )
						{
							Str255	errorStr;

							SysBeep( 1 );
							NumToString(status, errorStr);
							WarningAlert(	kWACautionAlertType,
											kWAOKStyle,
											STRx_PGPnet,
											kCantLaunchWebBrowserBecauseStrIndex,
											errorStr);
						}
					}
					else if ( message == kCreditsButtonMessage )
					{
						Str255	buttonTitle;
						
						if( credits )
						{
							theDialog->FindPaneByID( kAboutPicturePaneID )->
								Show();
							theDialog->FindPaneByID( kCreditsPicturePaneID )->
								Hide();
					#if CREDIT_RSA_BSAFE
							theDialog->FindPaneByID( kBSAFEPicturePaneID )->
								Hide();
					#endif
							
							GetIndString( buttonTitle, STRx_PGPnet,
								kAboutCreditsButtonTitleStrIndex );
						}
						else
						{
							theDialog->FindPaneByID( kCreditsPicturePaneID )->
								Show();
					#if CREDIT_RSA_BSAFE
							theDialog->FindPaneByID( kBSAFEPicturePaneID )->
								Show();
					#endif
							theDialog->FindPaneByID( kAboutPicturePaneID )->
								Hide();

							GetIndString( buttonTitle, STRx_PGPnet,
								kAboutInfoButtonTitleStrIndex );
						}
						
						((LControl *)theDialog->
							FindPaneByID(kCreditsButtonPaneID))->
							SetDescriptor( buttonTitle );

						credits = ! credits;
					}
				}
			}
			
			CloseResFile( libFileRefNum );
			UseResFile( saveResFile );
		}
	}
	
	if( ! didShowDialog )
		SysBeep( 1 );
}

	void
CPGPnet::ShowError(
	CPGPException &	inErr)
{
	WarningAlert(	kWAStopAlertType,
					kWAOKStyle,
					STRx_PGPnet,
					kErrorStringID,
					CString(CStringFromInt(inErr.GetError())),
					CString(inErr.what()));
}

#if PGP_DEBUG	// [

#define	kDebugMenuID	10001	// Must not conflict with regular menus

	void
CPGPnet::InstallDebugMenu(void)
{
	LMenu	*debugMenu;
	
	// Need to suspend leaking because PowerPlant menu objects leak like crazy
	MacLeaks_Suspend();
	
	debugMenu = new( LMenu )( kDebugMenuID, "\pDEBUG" );
	if( debugMenu != nil )
	{
		debugMenu->InsertCommand( "\pIKE Log", cmd_IKELog, 9999 );
		
		LMenuBar::GetCurrentMenuBar()->InstallMenu( debugMenu, 0 );
	}
	else
	{
		pgpDebugMsg( "InstallDebugMenu: Failed to create menu" );
	}

	MacLeaks_Resume();
}

	Boolean
CPGPnet::AllowSubRemoval(
	LCommander*	inSub	)
{
	if( inSub == mIKEWindow )
	{
		mIKEWindow->Hide();
		return FALSE;
	}
	return TRUE;
}

#endif

