/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: PGPnetService.h,v 1.20.4.1 1999/06/08 07:52:54 wprice Exp $
____________________________________________________________________________*/
#pragma once

#include "pgpNetLog.h"
#include "pgpNetServiceErrors.h"
#include "PGPnetModuleControl.h"

#define CKERR			if( IsPGPError( err ) ) goto done

	enum	{
				kStringListID		= 1024,
				kNeedOT13			= 1,
				kNoPGPSDK			= 2
			};

typedef struct PGPikeSAInfo
{
	struct PGPikeSAInfo *	next;
	PGPUInt32				index;
	PGPikeSA *				sa;
} PGPikeSAInfo;

void			PostGUINotification(	PGPInt16			stringID );
void			PostPNEvent(			UInt32				eventID,
										void *				data = NULL,
										PGPUInt32			dataLen = 0 );
void			AddLogEvent(			PGPnetLogEvent *	event );
PGPBoolean		LogIfPGPError(			PGPError			err,
										PGPUInt32			ipAddress = 0 );
PGPBoolean		LogIfOSStatus(			OSStatus			err );
void			LogServiceError(		PGPnetServiceError	svcErr,
										PGPUInt32			ipAddress = 0 );
void			EventIdle();
void			LoadPrefs();
void			SendHostsToModule();
void			ClientIDCheck( PGPikeMTClientIDCheck *	cic );
void			PolicyCheck(	PGPikeMTSASetup *	sas );
void			HandleModuleMessage( PGPnetModuleMsg *	msg );
void			RequestSA(	PGPInt32		hostIndex,
							PGPUInt32		destIP );
void			AddSAI( PGPikeSA *		sa );
void			RemoveSAI( PGPikeSA *		sa );
PGPikeSAInfo *	FindSAIData( PGPikeSA *		sa );
PGPikeSAInfo *	FindSAI( PGPikeSA *		sa );
PGPikeSAInfo *	FindSAIIndex( PGPUInt32	index );
PGPBoolean		SAMatch(
							PGPikeSA *		sa1,
							PGPikeSA *		sa2 );
OSStatus		MakeSureAppIsOpen();
PGPBoolean		PGPnetOpenKeyring();
void			PGPnetCloseKeyring();
PGPKeyRef		PGPnetGetLocalPGPAuthKey();
PGPKeyRef		PGPnetGetLocalX509AuthKey( PGPSigRef *			cert );
PGPBoolean		CheckRemoteCert(
							PGPUInt32			ipAddress,
							PGPKeyRef			rKey,
							PGPSigRef			rCert );

extern EndpointRef			gEndpoint;
extern PGPByte *			gInPacket;
extern PGPUInt32			gInPacketAddr;
extern PGPSize				gInPacketLen;
extern Boolean				gGo;
extern PGPUInt32			gLocalIP;
extern StreamRef			gModuleStream;

