/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: PGPnetModuleMessages.h,v 1.16 1999/05/05 09:54:19 wprice Exp $
____________________________________________________________________________*/
#pragma once

// We need to align all structures passed to and from the service to 68k
#pragma options align=mac68k

#include "pgpNetPrefsHostEntry.h"


extern "C" {

#define		I_PGPnetModuleMsg			'PS'

// This should not be sent, but is reserved to signal an empty message
#define		kPGPnetModuleNoMsg			0

// These shouldn't be sent directly, they are automatically sent during
// opening and closing of the control stream.
#define		kPGPnetModuleStartupMsg		1
#define		kPGPnetModuleShutdownMsg	2

// These messages are sent from the service to the module
#define		kPGPnetModuleNewSAMsg		10
#define		kPGPnetModuleNoSAMsg		11
#define		kPGPnetModuleUpdateSAMsg	12
#define		kPGPnetModulePrefsMsg		13
#define		kPGPnetModuleHostsMsg		14
#define		kPGPnetModuleBroadcastMsg	15

// These messages are sent in either direction
#define		kPGPnetModuleKillSAMsg		20

// These messages are sent from the module to the service
#define		kPGPnetModuleNeedSAMsg		30
#define		kPGPnetModuleRekeySAMsg		31
#define		kPGPnetModuleErrorMsg		32
#define		kPGPnetModuleSAStatsMsg		33

#define kPGPnetModuleName	"PGPnetModule"

struct PGPnetModuleStartupMsg
{
	PGPUInt16	type;					// kPGPnetModuleStartupMsg
	char		modName[13];			// "PGPnetModule"
};

struct PGPnetModuleNewSAMsg
{
	PGPUInt16	type;					// kPGPnetModuleNewSAMsg
	PGPUInt32	index;
	PGPikeSA	sa;
};

struct PGPnetModuleUpdateSAMsg
{
	PGPUInt16	type;					// kPGPnetModuleUpdateSAMsg
	PGPUInt32	index;
	PGPikeSA	sa;
};

struct PGPnetModuleKillSAMsg
{
	PGPUInt16	type;					// kPGPnetModuleKillSAMsg
	PGPUInt32	index;
};

struct PGPnetModuleRekeySAMsg
{
	PGPUInt16	type;					// kPGPnetModuleRekeySAMsg
	PGPUInt32	index;
};

struct PGPnetModuleNoSAMsg
{
	PGPUInt16				type;		// kPGPnetModuleNoSAMsg
	PGPUInt32				ipAddress;
	PGPUInt32				ipAddrStart;
	PGPUInt32				ipMaskEnd;
	PGPBoolean				destIsRange;
};

struct PGPnetModulePrefsMsg
{
	PGPUInt16	type;					// kPGPnetModulePrefsMsg
	PGPBoolean	enabled;
	PGPBoolean	allowUnconfigured;
	PGPBoolean	requireSecure;
};

struct	PGPnetModuleHostsMsg
{
	PGPUInt16			type;			// kPGPnetModuleHostsMsg
	PGPUInt32			numHosts;
	PGPNetPrefHostEntry	host[];
};

struct	PGPnetModuleNeedSAMsg
{
	PGPUInt16	type;					// kPGPnetModuleNeedSA
	PGPUInt32	ipAddress;
	PGPUInt32	ipAddrStart;
	PGPUInt32	ipMaskEnd;
	PGPBoolean	destIsRange;
};

struct	PGPnetModuleErrorMsg
{
	PGPUInt16	type;					// kPGPnetModuleError
	PGPError	err;
	PGPUInt32	addr;
};

struct	PGPnetModuleBroadcastMsg
{
	PGPUInt16	type;					// kPGPnetModuleBroadcastMsg
	PGPUInt32	addr;
};

/* This structure is stored in the userData field of the PGPikeSA */
typedef struct PGPnetIKESAUserData
{
	PGPUInt32		packetsSent; 		/* xfer packet count for this SA */
	PGPUInt32		bytesSent;			/* xfer byte count for this SA */
	PGPUInt32		sequenceWindowUpper;/* replay attacks */
	PGPUInt32		sequenceWindowLower;/* replay attacks */
	PGPUInt32		sequenceWindow;		/* replay attacks */
	PGPBoolean		reKeyInProgress;
} PGPnetIKESAUserData;

struct	PGPnetModuleSAStatsMsg
{
	PGPUInt16			type;	// kPGPnetModuleSAStats
	PGPUInt32			index;
	PGPnetIKESAUserData	stats;
};

union PGPnetModuleMsg
{
	UInt16						type;
	PGPnetModuleStartupMsg		startup;
	PGPnetModuleNewSAMsg		newSA;
	PGPnetModuleKillSAMsg		killSA;
	PGPnetModuleUpdateSAMsg		updateSA;
	PGPnetModuleHostsMsg		hosts;
	PGPnetModuleNoSAMsg			noSA;
	PGPnetModulePrefsMsg		prefs;
	PGPnetModuleBroadcastMsg	broadcast;
	PGPnetModuleNeedSAMsg		needSA;
	PGPnetModuleRekeySAMsg		rekeySA;
	PGPnetModuleSAStatsMsg		stats;
	PGPnetModuleErrorMsg		err;
};

}

#pragma options align=reset

