/* ======================================================================

	Function to encode and decode binary data to quoted-printable data.
	Code extracted from Eudora. Based on Steve Dorner's code.

	Filename:			CTEncode.h
	Last Edited:		March 7, 1997
	Authors:			Laurence Lundblade, Myra Callen
	Copyright:			1995, 1996 QUALCOMM Inc.
	Technical support:	<emsapi-info@qualcomm.com>
*/

#ifndef CTENCODE_H
#define CTENCODE_H

// Return values for encoders and decoders
#define kCTEDoneOK	0
#define kCTEFailed	1

typedef unsigned char *UPtr, *PStr;

/* ----------------- Quoted-Printable ------------------- */

// state buffer for QP encoding. Initialize all values to zero.
typedef enum {
	qpNormal,
	qpEqual,
	qpByte1
} QPStates;

// state buffer for encoding
typedef struct {
	long	nCurLineLen; /* Number of characters outputed to current line */
	char	cLastChar;	 /* Last character read in */
} EncQP, *EncQPPtr;

// state buffer for decoding
typedef struct {
	QPStates	state;
	Byte 		lastChar;
	long		spaceCount;
} DecQP, *DecQPPtr, **DecQPHandle;

// to do the quoted-printable encoding/decoding
long	EncodeQP(const UPtr binPtr, long binLen,
				 const UPtr qpPtr, long *qpBufSize, long *eQP);
long	DecodeQP(const UPtr qpPtr, long qpLen,
				 const UPtr binPtr, long *binLen,
				 const DecQPPtr dQP, long *decErrCnt);

/* ----------------- Base 64 ------------------- */

// state buffer for encoding
typedef struct {
	Byte	partial[4];
	short	partialCount;
	short	bytesOnLine;
} Enc64, *Enc64Ptr, **Enc64Handle;

// state buffer for decoding
typedef struct {
	short	decoderState;	/* which of 4 bytes are we seeing now? */
	long	invalCount;		/* how many bad chars found so far? */
	long	padCount;		/* how many pad chars found so far? */
	Byte	partial;		/* partially decoded byte from/for last/next time */
	Boolean	wasCR;			/* was the last character a carriage return? */
} Dec64, *Dec64Ptr, **Dec64Handle;

// to do the base 64 encoding/decoding
short Encode64(const UPtr bin, long len,
			   const UPtr sixFour, long *sixFourLen, Enc64Ptr e64);
short Decode64(const UPtr sixFour, long sixFourLen,
			   const UPtr bin, long *binLen,
			   const Dec64Ptr d64, long *decErrCnt);

/* ----------------- Identify the CTE ------------------- */
#define kCTEncodeHdrCStr	"Content-Transfer-Encoding:"
#define kCTEncodeHdrLen		26

// Valid return values for RFC822_ParseCTE which specify the transfer
// encoding found in the parsed header line
typedef enum {
	CTE_Error,
	CTE_Base64,
	CTE_QP,
	CTE_7bit,
	CTE_8bit,
	CTE_Binary,
	CTE_NONE,
	CTE_ASK
} TrEncType;

TrEncType	RFC822_ParseCTE(const char *src);
Handle		RFC822_MakeCTE(TrEncType mechanism);
char		*RFC822_ExtractCTE(const char *pFullHeader);

#endif /* ENCODING_H */
