/*____________________________________________________________________________
	CDecryptTranslator.cp
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CDecryptTranslator.cp,v 1.26 1999/04/26 09:39:59 heller Exp $
____________________________________________________________________________*/

#include <Script.h>
#include <TextUtils.h>
#include <string.h>

#include "pgpErrors.h"
#include "MacFiles.h"
#include "CDecryptTranslator.h"
#include "TranslatorIDs.h"
#include "MyMIMEUtils.h"
#include "PluginLibUtils.h"
#include "TranslatorUtils.h"
#include "TranslatorStrings.h"
#include "PassphraseCache.h"
#include "SignatureStatusMessage.h"
#include "PGPSharedEncryptDecrypt.h"


	PluginError
CDecryptTranslator::CanTranslate(
	emsTranslatorP 		trans,
	emsDataFileP 		inTransData,
   	emsResultStatusP	transStatus)
{
	PluginError	err	= EMSR_CANT_TRANS;
	
	(void) trans;
	(void) transStatus;
	
	err	= CanTranslateMIMEType( inTransData->context, inTransData->mimeInfo,
			"\pmultipart", "\pencrypted", "\papplication/pgp-encrypted");

	return( err );
}


	PluginError
CDecryptTranslator::TranslateFile(
	emsTranslatorP 		trans,
	emsDataFileP 		inFile,
    emsDataFileP 		outFile,
    emsResultStatusP 	transStatus)
{
	CComboError		err;
	FInfo			fInfo;
	DecryptVerifyEventHandlerData	eventData(this);
	
	(void) trans;
	
	FSpGetFInfo( &outFile->file, &fInfo );
	(void)FSpDelete( &outFile->file );
	
	err.pgpErr	= LoadDefaultKeySet( FALSE );
	if ( err.IsntError() )
	{
		PGPContextRef	c	= mContext;
		PGPKeySetRef	newKeysSet;
		
		err.pgpErr = PGPNewKeySet( c, &newKeysSet );
		if( err.IsntError() )
		{	
			err.pgpErr	= PGPDecode( c,
				PGPOInputFileFSSpec( c, &inFile->file ),
				PGPOOutputFileFSSpec( c, &outFile->file ),
				PGPOEventHandler( c, sPGPDecodeEventHandler, &eventData ),
				PGPOSendNullEvents( c, TRUE ),
				PGPOKeySetRef( c, mKeySet ),
				PGPOImportKeysTo( c, newKeysSet ),
				PGPOLastOption(c)
				);
			if ( err.IsError() )
			{
				gDecryptionPassphraseCache->Forget();
			}
			
			if( err.IsntError() &&
				PGPKeySetRefIsValid( eventData.mClientHandlerData.newKeySet ) )
			{
				err.pgpErr = PGPAddKeys(eventData.mClientHandlerData.newKeySet,
									newKeysSet );
				if( err.IsntError() )
				{
					err.pgpErr = PGPCommitKeyRingChanges( newKeysSet );
				}
			}

			if( err.IsntError() )
			{
				PGPUInt32	numNewKeys;
				PGPError	tempErr;
				
				tempErr = PGPCountKeys( newKeysSet, &numNewKeys );
				if( IsntPGPError( tempErr ) && numNewKeys > 0 )
				{
					// Offer to import the keys
					PGPKeySetRef	importSet;
					char			prompt[256];
					
					GetIndCString( prompt, kTranslatorStringsRID,
							kSelectiveImportAfterSendPromptStrIndex );
					
					tempErr = PGPSelectKeysDialog( c,
									kPGPSelectKeysImportVariation, prompt,
									newKeysSet, mKeySet, &importSet );
					
					if( IsntPGPError( tempErr ) )
					{
						(void) PGPSharedAddKeysToDefaultKeyring( importSet );
						(void) PGPFreeKeySet( importSet );
					}
				}
			}

			PGPFreeKeySet( newKeysSet );
		}
	}
	
	// we deleted the resource fork.
	// This makes Eudora unhappy.  Recreate one.
	(void)FSpCreateResFile( &outFile->file,
		fInfo.fdCreator, fInfo.fdType, smSystemScript );

	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), &inFile->file,
				"\pDecryptIn" );
	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), &outFile->file,
				"\pDecryptOut" );
	
	if ( err.IsntError() )
	{
		if ( ! eventData.mHaveSignatureData )
		{
			transStatus->code	= EMSR_OK;
		}
		else
		{
			PGPEventSignatureData const *	sigData;
			Str255							statusMessage;
				
			sigData				= &eventData.mSignatureData.sigData;
			transStatus->code	= SignatureDataToEudoraResult( sigData );

			GetSignatureStatusMessage( &eventData.mSignatureData,
					statusMessage );
			transStatus->desc = NewString( statusMessage );
		}
	}
	
	// parse the output to figure out what the MIME type is
	ParseFileForMIMEType( &outFile->file, &outFile->mimeInfo );
	
	
	if ( err.IsntError() )
	{
		RememberDecryptionPassBuffer( eventData.mClientHandlerData.passBuffer,
				eventData.mClientHandlerData.decryptionKey );
	}
	else
	{
		gDecryptionPassphraseCache->Forget();
		ReportError( err );
	}
		
	
	return( CComboErrorToEudoraError( err ) );
}











