/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.
	
	$Id: CAVPairDialog.h,v 1.2 1999/03/14 10:48:47 wprice Exp $
____________________________________________________________________________*/
#pragma once

#include "CPGPModalGrafPortView.h"
#include "CColumnTable.h"
#include "pgpEncode.h"

class CAVPairTable;

class CAVPairDialog : public CPGPModalGrafPortView
{
public:

	enum				{ class_ID = 'avPD' };
	
						CAVPairDialog(LStream * inStream);
	virtual				~CAVPairDialog();
	virtual void		FinishCreateSelf();
	virtual void		ListenToMessage(MessageT inMessage, void * ioParam);
	
	CComboError			Init(	PGPContextRef			pgpContext,
								PGPKeyServerClass		serverClass,
								PGPAttributeValue *		avList,
								PGPAttributeValue *		endAVList );
	Boolean				EditAVDialog( PGPAttributeValue *		avPair,
										PGPBoolean				newPair );
	PGPInt16			AttributeToMenuIndex(
									PGPAVAttribute			attribute );
	PGPAVAttribute		MenuIndexToAttribute(
									PGPInt16				index );
	
	CAVPairTable *			mAVTable;
	PGPAttributeValue *		mAVList;
	PGPAttributeValue *		mEndAVList;
private:
	LPushButton *			mAddButton,
				*			mEditButton,
				*			mRemoveButton;
	CPGPModalGrafPortView *	mEditAVDialog;
	PGPContextRef			mPGPContext;
};

class	CAVPairTable	:	public CColumnTable
{
public:
	enum { class_ID = 'avPT' };
						CAVPairTable(LStream *inStream) :
							CColumnTable( inStream ) { };
	virtual				~CAVPairTable() { };
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
};

