/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPOutlookExpressmenu.cp,v 1.1.4.1 1999/06/07 06:18:00 jason Exp $
____________________________________________________________________________*/

#include <AEObjects.h>
#include <AEPackObject.h>
#include <AERegistry.h>

#include <UAppleEventsMgr.h>
#include <UExtractFromAEDesc.h>

#include "pgpMemoryMgr.h"
#include "pgpMem.h"

#include "StPGPRefs.h"

#include "CPGPOutlookExpressmenu.h"



namespace {
	const DescType	pDisplayedMessage	=	'pMsg';
	const DescType	pContent			=	'ctnt';
	const DescType	cRecipient			=	'rcpt';
	const DescType	pAddress			=	'addr';
}



CPGPOutlookExpressmenu::CPGPOutlookExpressmenu(
	FSSpec *			inFSSpec,
	SPGPmenuMESPData *	inMESPData)
		: CPGPAppleEventmenu(inFSSpec, inMESPData)
{
}



CPGPOutlookExpressmenu::~CPGPOutlookExpressmenu()
{
}



	void
CPGPOutlookExpressmenu::AdjustMenuItems()
{
	mEncryptEnabled = false;
	mSignEnabled = false;
	mDecryptEnabled = false;
	mVerifyEnabled = false;

	try {
		DescType	windowClass = GetFrontWindowClass();
		
		switch (windowClass) {
/*
			case 'cwin':
			{
				StAEDescriptor	displayedMessage;

				GetDisplayedMessage(displayedMessage);
				if (displayedMessage.mDesc.descriptorType != typeNull) {
					mDecryptEnabled = true;
					mVerifyEnabled = true;
				}
			}
			break;
*/			
			case 'cDnW':
			case 'cDfW':
			{
				mEncryptEnabled = true;
				mSignEnabled = true;
				mDecryptEnabled = true;
				mVerifyEnabled = true;
			}
			break;
			
			
			case 'cInW':
			{
				mDecryptEnabled = true;
				mVerifyEnabled = true;
			}
			break;
		}
	}
	
	catch (...) {
	}

	CPGPAppleEventmenu::AdjustMenuItems();
}



	void
CPGPOutlookExpressmenu::GetSelection(
	PGPByte **	outData,
	PGPSize *	outDataSize)
{
	try {
		OSErr			err;
		StAEDescriptor	reply;
	
		*outDataSize = 0;
		{
			StAEDescriptor	getSelectionEvent;
			StAEDescriptor	nullDescriptor;
			StAEDescriptor	selectionProperty(static_cast<DescType>(pUserSelection));
			StAEDescriptor	selection;
			
			UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getSelectionEvent);
			err = ::CreateObjSpecifier(cProperty, nullDescriptor, formPropertyID, selectionProperty,
						false, selection);
			PGPThrowIfOSError_(err);
			err = ::AEPutParamDesc(getSelectionEvent, keyDirectObject, selection);
			PGPThrowIfOSError_(err);
			UAppleEventsMgr::SendAppleEventWithReply(getSelectionEvent, reply, false);
		}
		
		StAEDescriptor	errorCode(reply, keyErrorNumber);
		StAEDescriptor	userSelection(reply, keyDirectObject, typeChar);
		
		if (errorCode.mDesc.descriptorType != typeNull) {
			UExtractFromAEDesc::TheInt16(errorCode, err);
			PGPThrowIfOSError_(err);
		}
		if (userSelection.mDesc.descriptorType != typeNull) {
			*outDataSize = ::GetHandleSize(userSelection.mDesc.dataHandle);
			if (*outDataSize > 0) {
				*outData = static_cast<PGPByte *>(PGPNewData(mMemoryMgr, *outDataSize,
													kPGPMemoryMgrFlags_None));
				PGPThrowIfMemFail_(*outData);
				pgpCopyMemory(*userSelection.mDesc.dataHandle, *outData, *outDataSize);
				UAppleEventsMgr::CheckForMissedParams(reply);
			}
		}
	}
	
	catch (...) {
	}
}



	void
CPGPOutlookExpressmenu::SetSelection(
	PGPByte *	inData,
	PGPSize		inDataSize)
{
	OSStatus		err;
	StAEDescriptor	setSelectionEvent;
	StAEDescriptor	nullDescriptor;
	StAEDescriptor	selectionProperty(static_cast<DescType>(pUserSelection));
	StAEDescriptor	selection;
	
	UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAESetData, setSelectionEvent);
	err = ::CreateObjSpecifier(cProperty, nullDescriptor, formPropertyID, selectionProperty,
				false, selection);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setSelectionEvent, keyDirectObject, selection);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setSelectionEvent, keyAEData,
				StAEDescriptor(typeChar, inData, inDataSize));
	PGPThrowIfOSError_(err);
	UAppleEventsMgr::SendAppleEvent(setSelectionEvent);
}



	void
CPGPOutlookExpressmenu::GetContents(
	PGPByte **	outData,
	PGPSize *	outDataSize)
{
	OSErr			err;
	StAEDescriptor	reply;
	
	{
		StAEDescriptor	getContentsEvent;
		StAEDescriptor	nullDescriptor;
		DescType		first = kAEFirst;
		StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
		StAEDescriptor	window;
		StAEDescriptor	contentProperty(static_cast<DescType>(pContent));
		StAEDescriptor	content;
		
		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getContentsEvent);
		err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
					firstPosition, false, window);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, window, formPropertyID, contentProperty,
					false, content);
		PGPThrowIfOSError_(err);
		err = ::AEPutParamDesc(getContentsEvent, keyDirectObject, content);
		PGPThrowIfOSError_(err);
		UAppleEventsMgr::SendAppleEventWithReply(getContentsEvent, reply, false);
	}
	
	StAEDescriptor	errorCode(reply, keyErrorNumber);
	StAEDescriptor	contents(reply, keyDirectObject, typeChar);
	
	if (errorCode.mDesc.descriptorType != typeNull) {
		UExtractFromAEDesc::TheInt16(errorCode, err);
		PGPThrowIfOSError_(err);
	}
	*outDataSize = ::GetHandleSize(contents.mDesc.dataHandle);
	if (*outDataSize > 0) {
		*outData = static_cast<PGPByte *>(PGPNewData(mMemoryMgr, *outDataSize,
											kPGPMemoryMgrFlags_None));
		PGPThrowIfMemFail_(*outData);
		pgpCopyMemory(*contents.mDesc.dataHandle, *outData, *outDataSize);
		UAppleEventsMgr::CheckForMissedParams(reply);
	}
}



	void
CPGPOutlookExpressmenu::SetContents(
	PGPByte *	inData,
	PGPSize		inDataSize)
{
	OSStatus		err;
	StAEDescriptor	setContentsEvent;
	StAEDescriptor	nullDescriptor;
	DescType		first = kAEFirst;
	StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
	StAEDescriptor	window;
	StAEDescriptor	contentProperty(static_cast<DescType>(pContent));
	StAEDescriptor	content;
	
	UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAESetData, setContentsEvent);
	err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
				firstPosition, false, window);
	PGPThrowIfOSError_(err);
	err = ::CreateObjSpecifier(cProperty, window, formPropertyID, contentProperty,
				false, content);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setContentsEvent, keyDirectObject, content);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setContentsEvent, keyAEData,
				StAEDescriptor(typeChar, inData, inDataSize));
	PGPThrowIfOSError_(err);
	UAppleEventsMgr::SendAppleEvent(setContentsEvent);
}



	void
CPGPOutlookExpressmenu::GetRecipients(
	PGPUInt32 *			outNumRecipients,
	PGPRecipientSpec **	outRecipients)
{
	OSErr			err;
	StAEDescriptor	reply;
	
	*outNumRecipients = 0;
	{
		StAEDescriptor	saveWindowEvent;
		StAEDescriptor	nullDescriptor;
		DescType		first = kAEFirst;
		StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
		StAEDescriptor	window;
		
		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAESave, saveWindowEvent);
		err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
					firstPosition, false, window);
		PGPThrowIfOSError_(err);
		err = ::AEPutParamDesc(saveWindowEvent, keyDirectObject, window);
		PGPThrowIfOSError_(err);
		UAppleEventsMgr::SendAppleEvent(saveWindowEvent);
	}
	
	{
		StAEDescriptor	getRecipientsEvent;
		StAEDescriptor	displayedMessage;
		DescType		all = kAEAll;
		StAEDescriptor	allPosition(typeAbsoluteOrdinal, &all, sizeof(all));
		StAEDescriptor	recipientElements;
		StAEDescriptor	addressProperty(pAddress);
		StAEDescriptor	address;
		StAEDescriptor	emailAddresses;
		
		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getRecipientsEvent);
		GetDisplayedMessage(displayedMessage);
		err = ::CreateObjSpecifier(cRecipient, displayedMessage, formAbsolutePosition, allPosition,
					false, recipientElements);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, recipientElements, formPropertyID, addressProperty,
					false, address);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, address, formPropertyID, addressProperty, false,
					emailAddresses);
		err = ::AEPutParamDesc(getRecipientsEvent, keyDirectObject, emailAddresses);
		PGPThrowIfOSError_(err);
		try {
			UAppleEventsMgr::SendAppleEventWithReply(getRecipientsEvent, reply, false);
		}
		
		catch (...) {
			return;
		}
	}
	
	StAEDescriptor		errorCode(reply, keyErrorNumber);
	StAEDescriptor		recipientList(reply, keyDirectObject, typeAEList);
	SInt32				numRecipients;
	StPGPDataRef		recipientBuffer;
	PGPRecipientSpec *	recipients;
	AEKeyword			keyWord;
	PGPSize				dataSize;
	
	if (errorCode.mDesc.descriptorType != typeNull) {
		UExtractFromAEDesc::TheInt16(errorCode, err);
		PGPThrowIfOSError_(err);
	}
	err = ::AECountItems(recipientList, &numRecipients);
	PGPThrowIfOSError_(err);
	if (numRecipients > 0) {
		recipientBuffer = static_cast<PGPByte *>(PGPNewData(mMemoryMgr, numRecipients *
												sizeof(PGPRecipientSpec), kPGPMemoryMgrFlags_None));
		PGPThrowIfMemFail_(recipientBuffer);
		recipients = reinterpret_cast<PGPRecipientSpec*>(static_cast<PGPByte *>(recipientBuffer));
		for (PGPUInt32 i = 1; i <= numRecipients; i++) {
			StAEDescriptor	anAddress;
			
			err = ::AEGetNthDesc(recipientList, i, typeChar, &keyWord, anAddress);
			PGPThrowIfOSError_(err);
			dataSize = ::GetHandleSize(anAddress.mDesc.dataHandle);
			if (dataSize > 255) {
				dataSize = 255;
			}
			recipients[i - 1].type = kPGPRecipientSpecType_UserID;
			recipients[i - 1].locked = false;
			pgpCopyMemory(*anAddress.mDesc.dataHandle, recipients[i - 1].u.userIDStr, dataSize);
			recipients[i - 1].u.userIDStr[dataSize] = 0;
		}
		UAppleEventsMgr::CheckForMissedParams(reply);
		*outNumRecipients = numRecipients;
		*outRecipients = recipients;
		recipientBuffer = 0;
	}
}



	DescType
CPGPOutlookExpressmenu::GetFrontWindowClass()
{
	DescType		result;
	OSErr			err;
	StAEDescriptor	reply;
	
	{
		StAEDescriptor	getWindowClassEvent;
		StAEDescriptor	nullDescriptor;
		DescType		first = kAEFirst;
		StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
		StAEDescriptor	window;
		StAEDescriptor	classProperty(static_cast<DescType>(pClass));
		StAEDescriptor	windowClass;

		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getWindowClassEvent);
		err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
					firstPosition, false, window);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, window, formPropertyID, classProperty,
					false, windowClass);
		PGPThrowIfOSError_(err);
		err = ::AEPutParamDesc(getWindowClassEvent, keyDirectObject, windowClass);
		PGPThrowIfOSError_(err);
		UAppleEventsMgr::SendAppleEventWithReply(getWindowClassEvent, reply, false);
	}
	
	StAEDescriptor	errorCode(reply, keyErrorNumber);
	StAEDescriptor	frontWindowClass(reply, keyDirectObject, typeType);
	
	if (errorCode.mDesc.descriptorType != typeNull) {
		UExtractFromAEDesc::TheInt16(errorCode, err);
		PGPThrowIfOSError_(err);
	}
	UExtractFromAEDesc::TheType(frontWindowClass, result);
	UAppleEventsMgr::CheckForMissedParams(reply);
	
	return result;
}


	void
CPGPOutlookExpressmenu::GetDisplayedMessage(
	AEDesc *	outDisplayedMessage)
{
	OSErr			err;
	StAEDescriptor	reply;
	
	{
		StAEDescriptor	getDisplayedMessageEvent;
		StAEDescriptor	nullDescriptor;
		DescType		first = kAEFirst;
		StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
		StAEDescriptor	window;
		StAEDescriptor	displayedMessageProperty(static_cast<DescType>(pDisplayedMessage));
		StAEDescriptor	displayedMessage;

		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getDisplayedMessageEvent);
		err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
					firstPosition, false, window);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, window, formPropertyID, displayedMessageProperty,
					false, displayedMessage);
		PGPThrowIfOSError_(err);
		err = ::AEPutParamDesc(getDisplayedMessageEvent, keyDirectObject, displayedMessage);
		PGPThrowIfOSError_(err);
		UAppleEventsMgr::SendAppleEventWithReply(getDisplayedMessageEvent, reply, false);
	}
	
	StAEDescriptor	errorCode(reply, keyErrorNumber);
	StAEDescriptor	frontWindowClass(reply, keyDirectObject, typeType);
	
	if (errorCode.mDesc.descriptorType != typeNull) {
		UExtractFromAEDesc::TheInt16(errorCode, err);
		PGPThrowIfOSError_(err);
	}
	err = ::AEGetParamDesc(reply, keyDirectObject, typeWildCard, outDisplayedMessage);
	PGPThrowIfOSError_(err);
	UAppleEventsMgr::CheckForMissedParams(reply);
}