/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CCommandKeyWell.cp,v 1.3 1999/04/20 11:53:55 wprice Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>
#include <LCheckBox.h>
#include <UGraphicUtils.h>
#include <UDrawingState.h>
#include <UDrawingUtils.h>
#include <UAttachments.h>
#include <UTextTraits.h>
#include <ctype.h>

#include "CCommandKeyWell.h"
#include "MacStrings.h"


CCommandKeyWell::CCommandKeyWell(LStream * inStream)
	: LCaption(inStream)
{
	mModifiers	= kMenuNoModifiers;
	mKey		= 'A';
	ResetText();
}

CCommandKeyWell::~CCommandKeyWell()
{
}

	void
CCommandKeyWell::FinishCreateSelf()
{
	StartRepeating();
}

	Boolean
CCommandKeyWell::ObeyCommand(CommandT inCommand, void *ioParam)
{
	Boolean		cmdHandled = true;
	
	switch( inCommand )
	{
		case msg_TabSelect:
			cmdHandled = IsEnabled();
			break;
		
		default:
			cmdHandled = LCommander::ObeyCommand( inCommand, ioParam );
			break;
	}
	
	return( cmdHandled );
}

	void
CCommandKeyWell::ClickSelf(
	const SMouseDownEvent & )
{
	if( !IsTarget() )
		SwitchTarget( this );
}

	void
CCommandKeyWell::DrawSelf()
{
	Rect localFrame;
	
	FocusDraw();
	CalcLocalFrameRect (localFrame);
	ApplyForeAndBackColors();
	DrawBackground(	localFrame);
	DrawText(		localFrame);
}

	void
CCommandKeyWell::DrawBackground(
	const Rect & localFrame)
{
	Rect frameCopy = localFrame;
	::InsetRect(&frameCopy, 1, 1);
	::EraseRect(&frameCopy);
}

	void
CCommandKeyWell::DrawText(
	const Rect & localFrame)
{
	Rect frame = localFrame;		// added
	::InsetRect(&frame, 4, 2);		// added
	frame.top--;					// added
	
	Int16	just = UTextTraits::SetPortTextTraits(mTxtrID);
	
	RGBColor	textColor;
	::GetForeColor(&textColor);
	
	ApplyForeAndBackColors();
	::RGBForeColor(&textColor);
	
	UTextDrawing::DrawWithJustification((Ptr)&mText[1], mText[0], frame, just);
	TextFont( 0 );
	DrawChar( mKey );
}

	void
CCommandKeyWell::ResetText()
{
	mText[0] = 0;
	if( mModifiers & kMenuShiftModifier )
		mText[++mText[0]] = 0x05;
	if( mModifiers & kMenuControlModifier )
		mText[++mText[0]] = 0x06;
	if( mModifiers & kMenuOptionModifier )
		mText[++mText[0]] = 0x07;
	mText[++mText[0]] = 0x11;
}

#define kMaxKeyMapEntries	128
static char	sKeyMap[kMaxKeyMapEntries] = {
	'=', '9', '7', '-', '8', '0', ']', 'O',
	'Y', 'T', '1', '2', '3', '4', '6', '5',
	'C', 'V', 0,   'B', 'Q', 'W', 'E', 'R',
	'A', 'S', 'D', 'F', 'H', 'G', 'Z', 'X',
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, '`', 0, 0, 0, 0, 0,
	'K', ';', '\\', ',', '/', 'N', 'M', '.',
	'U', '[', 'I', 'P', 0, 'L', 'J', '\'',
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};

	void
CCommandKeyWell::SpendTime(
	const EventRecord&	inMacEvent )
{
	KeyMap		keyboard;
	short		keyIndex;
	
	if( IsTarget() && ( inMacEvent.modifiers & cmdKey ) )
	{
		::GetKeys( (ulong *)&keyboard );
		for( keyIndex = 0; keyIndex < kMaxKeyMapEntries; keyIndex++ )
		{
			if( ( ( keyboard[keyIndex / 32] & ( 1 << ( keyIndex % 32 ) ) ) > 0 )
				&& ( sKeyMap[keyIndex] > 0 ) )
			{
				mKey = sKeyMap[keyIndex];
				mModifiers	= kMenuNoModifiers;
				if( inMacEvent.modifiers & shiftKey )
					mModifiers |= kMenuShiftModifier;
				if( inMacEvent.modifiers & optionKey )
					mModifiers |= kMenuOptionModifier;
				if( inMacEvent.modifiers & controlKey )
					mModifiers |= kMenuControlModifier;
				ResetText();
				DrawSelf();
				break;
			}
		}
	}
}

	void
CCommandKeyWell::SetCKW(
	UInt8			modifiers,
	UInt8			triggerKey )
{
	mModifiers	= modifiers;
	mKey		= triggerKey;
	ResetText();
	DrawSelf();
}

	void
CCommandKeyWell::GetCKW(
	UInt8			&modifiers,
	UInt8			&triggerKey )
{
	modifiers	= mModifiers;
	triggerKey	= mKey;
}

	Boolean
CCommandKeyWell::HandleKeyPress(const EventRecord&	inKeyEvent)
{
	Boolean		keyHandled	= true;
	
	keyHandled = LCommander::HandleKeyPress(inKeyEvent);
	return keyHandled;
}

