/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CEventAvailPatcher.cp,v 1.4 1999/04/10 11:12:07 jason Exp $
____________________________________________________________________________*/

#include <Traps.h>

#include <SetupA4.h>

#include "CEventAvailPatcher.h"



// Define statics
CEventAvailPatcher *	CEventAvailPatcher::sEventAvailPatcher = nil;

CEventAvailPatcher::CEventAvailPatcher()
{
	// Current version will only install one patch
	if (sEventAvailPatcher == nil) {
		Patch(_EventAvail, kProcInfo, (ProcPtr) EventAvailCallback);
		sEventAvailPatcher = this;
	}
}



CEventAvailPatcher::~CEventAvailPatcher()
{
}



	Boolean
CEventAvailPatcher::NewEventAvail(
	EventMask		eventMask,
	EventRecord *	theEvent)
{
	// default just calls through to the original
	return OldEventAvail(eventMask, theEvent);
}



	Boolean
CEventAvailPatcher::OldEventAvail(
	EventMask		eventMask,
	EventRecord *	theEvent)
{
#if	TARGET_RT_MAC_CFM
	return (Boolean) ::CallUniversalProc(	mOldRoutine,
											kProcInfo,
											eventMask,
											theEvent);
#else
	return ((EventAvailProc) mOldRoutine)(	eventMask,
											theEvent);
#endif
}



	pascal Boolean
CEventAvailPatcher::EventAvailCallback(
	EventMask		eventMask,
	EventRecord *	theEvent)
{
	EnterCallback();

	Boolean	result = false;

	try {
		result = sEventAvailPatcher->NewEventAvail(	eventMask,
													theEvent);
	}
	
	catch(...) {
	}
	
	ExitCallback();
	return result;
}
