/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CShareholderList.cp,v 1.5 1999/03/10 02:39:58 heller Exp $
____________________________________________________________________________*/

#include <Fonts.h>

#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>
#include <LTableArrayStorage.h>
#include <UGAColorRamp.h>
#include <UDrawingUtils.h>

#include "MacStrings.h"

#include "CShareholderList.h"

static const ResIDT	kRSAUserIDIconID	=	3002;
static const ResIDT	kDHUserIDIconID		=	3020;
static const ResIDT kConventionalIconID	=	3032;

const Int16		kUserIDColumnWidth		=	260;
const Int16		kSharesColumnWidth		=	32;
const Int16		kUserIDStringLength		=	256;
const Int16		kLeftIndent				=	2;
const Int16		kIconWidth				=	16;
const Int16		kIconHeight				=	16;


CShareholderList::CShareholderList(
	LStream	*inStream)
		: LTableView(inStream)
{
	mTableGeometry = new LTableMonoGeometry(this, mFrameSize.width, 18);
	mTableSelector = new LTableSingleSelector(this);
	mTableStorage = new LTableArrayStorage(this, sizeof(ShareholderListEntry));
}

	void
CShareholderList::DrawSelf()
{
	Rect frame;

	RGBForeColor(&UGAColorRamp::GetColor(colorRamp_Black));
	RGBBackColor(&UGAColorRamp::GetColor(colorRamp_White));
	CalcLocalFrameRect(frame);
	EraseRect(&frame);
	LTableView::DrawSelf();
}

	void
CShareholderList::DrawCell(
	const STableCell	&inCell,
	const Rect			&inLocalRect)
{
	StDeviceLoop		devLoop(inLocalRect);		
	SInt16				depth,
						iconID;
	Uint32				dataSize = sizeof(ShareholderListEntry);
	ShareholderListEntry holder;
	Str255				str;
	Rect				iconRect;

	while(devLoop.NextDepth(depth))
	{
		::RGBForeColor(&UGAColorRamp::GetColor(colorRamp_Black));
		::RGBBackColor(&UGAColorRamp::GetColor(colorRamp_White));
		::EraseRect(&inLocalRect);
		GetCellData(inCell, &holder, dataSize);
		
		iconRect.left 	= 	inLocalRect.left + kLeftIndent;
		iconRect.top	=	inLocalRect.top + 1;
		iconRect.right 	= 	iconRect.left + kIconWidth;
		iconRect.bottom = 	iconRect.top + kIconHeight;
		
		switch( holder.algorithm )
		{
			case kPGPPublicKeyAlgorithm_DSA:
				iconID = kDHUserIDIconID;
				break;
			case kPGPPublicKeyAlgorithm_RSA:
				iconID = kRSAUserIDIconID;
				break;
			default:
				iconID = kConventionalIconID;
				break;
		}
		PlotIconID(&iconRect, atNone, ttNone, iconID );
		
		CToPString( holder.name, str );
		::TextSize(9);
		::TextFont(kFontIDGeneva);
		::TextFace(0);
		::TruncString(	kUserIDColumnWidth - 22, str, truncMiddle);
		::MoveTo(inLocalRect.left + 22, inLocalRect.bottom - 5);
		::DrawString(str);
		::MoveTo(	inLocalRect.left + kUserIDColumnWidth + 4,
					inLocalRect.bottom -5);
		NumToString( holder.numShares, str );
		::DrawString(str);
	}
}

	void
CShareholderList::DeactivateSelf()
{
	Draw( NULL );

	LTableView::DeactivateSelf();
}

	void
CShareholderList::ActivateSelf()
{
	LTableView::ActivateSelf();

	Refresh();
}

	void
CShareholderList::ClickSelf(
	const SMouseDownEvent &inMouseDown)
{
	LTableView::ClickSelf(inMouseDown);
}

	void
CShareholderList::SelectionChanged()
{
	BroadcastMessage(kSLSelectionChangedMessageID, NULL);
}

