/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CIconPane.cp,v 1.2 1999/03/10 02:34:06 heller Exp $
____________________________________________________________________________*/

#include "CIconPane.h"



CIconPane::CIconPane(
	LStream *	inStream)
	  : mOwnsSuite(false), mIconSuite(NULL), mAlignment(atNone), mTransform(ttNone),
	    LIconPane(inStream)
{
}



CIconPane::~CIconPane()
{
	if (mOwnsSuite) {
		::DisposeIconSuite(mIconSuite, true);
	}
}	


	void
CIconPane::SetIconSuite(
	Handle	inIconSuite,
	Boolean	inOwnsSuite)
{
	if (mOwnsSuite) {
		::DisposeIconSuite(mIconSuite, true);
	}
	mIconSuite = inIconSuite;
	mOwnsSuite = inOwnsSuite;
}



	void
CIconPane::DrawSelf()
{
	Rect	frame;
	CalcLocalFrameRect(frame);
	
	if (mIconSuite != NULL) {
		::PlotIconSuite(&frame, mAlignment, mTransform, mIconSuite);
	} else {
		::PlotIconID(&frame, mAlignment, mTransform, mIconID);
	}
}
