/*____________________________________________________________________________
	Copyright (C) 1998 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CPGPAMTabsControlImp.cp,v 1.6 1999/03/10 02:36:23 heller Exp $
____________________________________________________________________________*/

#include <Appearance.h>
#include <Gestalt.h>
#include <UGAColorRamp.h>

#include "pgpMem.h"
#include "MacBasics.h"
#include "CPGPAMTabsControlImp.h"

CPGPAMTabsControlImp::CPGPAMTabsControlImp(LStream *inStream)
		: LAMTabsControlImp(inStream)
{
	long	gestaltResult;
	
	mRunningKaleidoscope = IsntErr( Gestalt( 'Copl', &gestaltResult ) );
}


CPGPAMTabsControlImp::~CPGPAMTabsControlImp()
{
}


	bool
CPGPAMTabsControlImp::ApplyForeAndBackColors() const
{
	if( IsntNull( mMacControlH ) )
	{
		SetThemeWindowBackground( (**mMacControlH).contrlOwner,
					kThemeActiveDialogBackgroundBrush, FALSE );
					
		if( ! mRunningKaleidoscope )
		{
			CGrafPtr	controlPort;
			
			controlPort = (CGrafPtr) (**mMacControlH).contrlOwner;
			
			if( controlPort->rgbBkColor.red == 0xDDDD &&
				controlPort->rgbBkColor.green == 0xDDDD &&
				controlPort->rgbBkColor.blue == 0xDDDD )
			{
				RGBColor	backColor;
				
				backColor = UGAColorRamp::GetColor( colorRamp_Gray1 );
				RGBBackColor( &backColor );
			}
		}
	}
	
	return( true );
}

