/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPPassphraseDialog.cp,v 1.10 1999/03/10 02:54:01 heller Exp $
____________________________________________________________________________*/

#include <string.h>

#include <PP_Messages.h>
#include <URegistrar.h>

#include "MacDebug.h"
#include "MacResources.h"
#include "MacSecureMemory.h"
#include "MacStrings.h"
#include "pgpErrors.h"
#include "pgpKeys.h"
#include "pgpMem.h"
#include "pgpUserInterface.h"
#include "pgpUtilities.h"

#include "CPGPPassphraseGrafPortView.h"
#include "CPGPRecipientTable.h"
#include "CPGPConfPassphraseGrafPort.h"
#include "CPGPSignPassphraseGrafPort.h"
#include "CPGPDecrPassphraseGrafPort.h"
#include "PGPsdkUILibUtils.h"
#include "PGPsdkUILibDialogs.h"
#include "pgpDialogs.h"

const ResIDT kPGPPassphraseDialogID					= 4748;
const ResIDT kPGPSigningPassphraseDialogID			= 4749;
const ResIDT kPGPConfirmationPassphraseDialogID		= 4750;
const ResIDT kPGPDecryptionPassphraseDialogID		= 4751;
const ResIDT kPGPKeyPassphraseDialogID				= 4753;


	PGPError
pgpPassphraseDialogPlatform(
	PGPContextRef					context,
	CPGPPassphraseDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		RegisterClass_( CPGPPassphraseGrafPortView );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPPassphraseGrafPortView::CreateDialog(
							kPGPPassphraseDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPPassphraseGrafPortView	*passphraseGrafPortView;
		
			passphraseGrafPortView =
					(CPGPPassphraseGrafPortView *) GetWRefCon( theDialog );
			pgpAssertAddrValid( passphraseGrafPortView, VoidAlign );
			
			err = passphraseGrafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = passphraseGrafPortView->DoDialog();
			}
			
			delete( passphraseGrafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}

	PGPError
pgpKeyPassphraseDialogPlatform(
	PGPContextRef					context,
	CPGPKeyPassphraseDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		RegisterClass_( CPGPKeyPassphraseGrafPortView );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPKeyPassphraseGrafPortView::CreateDialog(
							kPGPKeyPassphraseDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPKeyPassphraseGrafPortView	*passphraseGrafPortView;
		
			passphraseGrafPortView =
				(CPGPKeyPassphraseGrafPortView *) GetWRefCon( theDialog );
			pgpAssertAddrValid( passphraseGrafPortView, VoidAlign );

			err = passphraseGrafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = passphraseGrafPortView->DoDialog();
			}
			
			delete( passphraseGrafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}

	PGPError
pgpSigningPassphraseDialogPlatform(
	PGPContextRef						context,
	CPGPSigningPassphraseDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		RegisterClass_( CPGPSigningPassphraseGrafPortView );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPSigningPassphraseGrafPortView::CreateDialog(
							kPGPSigningPassphraseDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPSigningPassphraseGrafPortView	*passphraseGrafPortView;
		
			passphraseGrafPortView =
				(CPGPSigningPassphraseGrafPortView *) GetWRefCon( theDialog );
			pgpAssertAddrValid( passphraseGrafPortView, VoidAlign );

			err = passphraseGrafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = passphraseGrafPortView->DoDialog();
			}
			
			delete( passphraseGrafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}

	PGPError
pgpConfirmationPassphraseDialogPlatform(
	PGPContextRef								context,
	CPGPConfirmationPassphraseDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		RegisterClass_( CPGPConfPassphraseGrafPortView );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPConfPassphraseGrafPortView::CreateDialog(
							kPGPConfirmationPassphraseDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPConfPassphraseGrafPortView	*passphraseGrafPortView;
		
			passphraseGrafPortView =
				(CPGPConfPassphraseGrafPortView *) GetWRefCon( theDialog );
			pgpAssertAddrValid( passphraseGrafPortView, VoidAlign );
			
			err = passphraseGrafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = passphraseGrafPortView->DoDialog();
			}
			
			delete( passphraseGrafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}

	PGPError
pgpDecryptionPassphraseDialogPlatform(
	PGPContextRef							context,
	CPGPDecryptionPassphraseDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		RegisterClass_( CPGPDecryptionPassphraseGrafPortView );
		RegisterClass_( CPGPRecipientTable );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPSigningPassphraseGrafPortView::CreateDialog(
							kPGPDecryptionPassphraseDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPDecryptionPassphraseGrafPortView	*passphraseGrafPortView;
		
			passphraseGrafPortView = (CPGPDecryptionPassphraseGrafPortView *)
											GetWRefCon( theDialog );
			pgpAssertAddrValid( passphraseGrafPortView, VoidAlign );

			err = passphraseGrafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = passphraseGrafPortView->DoDialog();
			}
			
			delete( passphraseGrafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}






