#!/bin/sh
export PGPPATH=.

echo ========== Generating key:
#needs existing pubring.pkr with good parameters in the first key.
#I could use newkeygen, but it takes a while...

if [ -s pubring.pkr ] ; then
  ./new5key -K 0 -k 0 -r pubring.pkr -u "Test Key" #-p testpass
else
  ./new5key -g 768 -u "Test Key" #-p testpass
fi

#this probably should be a cat, but...
mv pubnew.pkr pubring.pkr
mv secnew.skr secring.skr

#fix pubring to allow crypyption
./lookup5 -o rdx.one -x -m Test
./pgp5sign -i rdx.one -t 24 -p testpass >>pubring.pkr
echo -ne "\260\001\147" >>pubring.pkr
#strictly, you also need to use pgpk -s to sign the DSS key on the pubring

../minipgp/keygen -n 512 >secring.pgp 2>pubring.pgp

echo ========== Crypt test

./pgp5cryp -i new5key -o rdx.one -l rdx 
../minipgp/minipgp -i rdx.one -o rdx.two -z
./pgp5cryp -i rdx.two -o rdx.one
./pgp5cryp -i rdx.one -k 0 >rdx.enc

./pgp5cryp -d -i rdx.enc -o rdx.one -p testpass
./pgp5sign -v -i rdx.one -o rdx.two
../minipgp/minipgp -i rdx.two -o rdx.one
./pgp5sign -v -i rdx.one -o rdx
cmp rdx new5key

echo ========== Crypt and One pass sig test

for pka in 16 1; do #1 if RSAKEY is defined
  for siga in 1 16 17; do #1 for RSAKEY, 17 for not NOELGKEY
    for hash in 1 2 3 4; do #3 if RIPEMD is defined
      for alg in 0 1 2 3 4 6; do
        echo testing enc $pka/$alg, hash $hash, sig $siga

        ./pgp5cryp -i new5key -o rdx.one -l rdx
        ./pgp5sign -o rdx.pre -A $siga -a $hash -t 1 -p testpass -1 >rdx.pre
        ./pgp5sign -i new5key -o rdx.two -A $siga -a $hash -t 1 -p testpass
        cat rdx.pre rdx.one rdx.two >rdx.all
        ../minipgp/minipgp -i rdx.all -o rdx.one -z 
        ./pgp5cryp -i rdx.one -o rdx.two
        ./pgp5cryp -i rdx.two -o rdx.enc -a $alg -A $pka -k 0
        rm -f rdx rdx.pre rdx.one rdx.two rdx.all

        ./pgp5cryp -d -i rdx.enc -o rdx.one -p testpass
        ./pgp5sign -v -i rdx.one -o rdx.two
        ../minipgp/minipgp -i rdx.two -o rdx.one
        ./pgp5sign -v -i rdx.one -o rdy.out
        if cmp rdy.out new5key ; then echo decrypt ok; else exit 0; fi
      done
    done
  done
done

echo ========== Detached Signature test

for siga in 1 16 17; do
  for hash in 1 2 3; do
    ./pgp5sign -i pgp5cryp -o pgp5decr.sig -p testpass -a $hash -A $siga
    ./pgp5sign -v -i pgp5cryp -s pgp5decr.sig
  done
done

rm pgp5decr.sig