#include <rand.h>
#include "libpgp5.h"

/*------------------------------------*/
void cnvenc5(FILE * inf, FILE * outf,
             unsigned char *convkey, unsigned int cvealg)
{
  unsigned char dbuf[10000], *bp;
  int j, k;

  fputc(0xc9, outf);            /* conventional encryption packet */
  memset(dbuf, 0, 256);
  cfbinit(convkey, dbuf, cvealg);

  bp = &dbuf[1];                /* special PGP iv header */
  dbuf[0] = 0xed;
  RAND_bytes(bp, 8);
  bp[8] = bp[6];
  bp[9] = bp[7];
  docfb(bp, 10, 1);
  cfbreset(&bp[2]);             /* PGP special restart */
  bp += 10;
  j = 10;
  for (;;) {                    /* packetize and encrypt */
    k = fread(bp, 1, 8192 - j, inf);
    if (k <= 0)
      break;
    docfb(bp, k, 1);
    j += k;
    if (j == 8192) {
      fwrite(dbuf, 1, j + 1, outf);
      bp = &dbuf[1];
      j = 0;
    } else {
      if (j > 192) {
        fputc(0xc0 | ((j - 192) >> 8), outf);
        dbuf[0] = j - 192;
      } else
        dbuf[0] = j;
      fwrite(dbuf, 1, j + 1, outf);
    }
  }
}
