#  This is version 1.1 of Crowds
# 
#  The authors of this software are Mike Reiter and Avi Rubin
#               Copyright (c) 1997 by AT&T.
#  Permission to use, copy, and modify this software without fee
#  is hereby granted, provided that this entire notice is included in
#  all copies of any software which is or includes a copy or
#  modification of this software and in all copies of the supporting
#  documentation for such software.
# 
#  SOME PARTS OF CROWDS MAY BE RESTRICTED UNDER UNITED STATES EXPORT
#  REGULATIONS.
# 
# 
#  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
#  WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
#  REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
#  OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.

# This package contains the routines for a pseudorandom number generator.
# It takes a random see as input and uses DES to build a pseudorandom stream.
# Routines are also provided to return a random integer or string once the
# generator is initialized.


package Random;

use des;


sub new {
    my ($seed) = @_;
    my $key = "00000000";

    while ($seed =~ s/(.{1,8})//so) {
	$key ^= $1;
    }

    my @ks = des::des_set_key($key);
    my $prng = bless { key     => \@ks,
		       counter => 0,
		       buffer  => "" }, 'Random';

    return $prng;
}


sub size {
    my ($prng) = @_;
    return length($prng->{buffer});
}


sub generate {
    my ($prng, $size) = @_;
    my $add;
    my $padded;

    while ($size > 0) {
        $padded = '0'x(8 - length($prng->{counter})).$prng->{counter};
	$add = des::des_ecb_encrypt($prng->{key}, 1, $padded);
	$size -= length($add);
	$prng->{buffer} .= $add;
        $prng->{counter} += 1;
    }
}


sub get_rand_string {
    my ($prng, $size) = @_;
    $prng->generate($size - length($prng->{buffer}));
    my $rand = substr($prng->{buffer}, 0, $size);
    $prng->{buffer} = substr($prng->{buffer}, $size);
    return $rand;
}


sub get_rand_int {
    my ($prng, $limit) = @_;
    $prng->generate(2 - length($prng->{buffer}));
    my $rand = substr($prng->{buffer}, 0, 2);
    $prng->{buffer} = substr($prng->{buffer}, 2);
    $rand = hex(join('',unpack("H*",$rand))) % $limit;
    if ($rand < 0) {
	$rand = -$rand;
    }
    return $rand;
}

1;
