/****************************************************************************
  This file is part of the Freedom Remailer.  The encrypt_sub() function
  is borrowed from Andy Dustman's Encrypt-Subject patch to Matt Ghio's
  remailer distribution.  All changes and other code are:
  Copyright (C) 1997  Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include "config.h"
#include "idea.h"
#include "md5.h"

int scan_subject(const char *bodyfile)
{
  int found_subject = 0;
  FILE *in;
  char line[BUFSIZ], tmpline[BUFSIZ], subj[BUFSIZ];

  in = fopen(bodyfile, "r");
  while (fgets(line, sizeof(line), in)) {
    strcpy(tmpline, line);
    stringlower(tmpline);
    if (strlen(line) <= 1) {
      fclose(in);
      return found_subject;
    } else {
      if (strncmp(tmpline, "subject:", 8) == 0) {
	found_subject++;
	strcpy (subj, line + 8);
	chop(subj);
	if (blocked(subj, SUBJ_BLOCK)) {
	  if (DEBUG) {
	    printf("Blocked %s", line);
	    fflush(stdout);
	  }
	  fclose(in);
	  return -1;
	}
      }
    }
  }
  /* no blank line found */
  fclose(in);
  return found_subject;
}

void encrypt_sub(char *origfile, const char *key)
/* IDEA-encrypt MD5-hash of ##'ed Subject: line with MD5-hash of "key" */
{
  FILE *in, *out;
  int headers = 1, colhead = 0, addhead = 0, linenum = 0, x;
  char tempfile[BUFSIZ], line[BUFSIZ], tmpline[BUFSIZ];
  struct MD5Context subjkeyDigest, subjectDigest;
  struct IdeaCfbContext subjcontext;
  unsigned char subjIDEAkey[16], subjPT[16];
  unsigned char subjCT[24]; /* includes IV */

  MD5Init(&subjkeyDigest);
  MD5Update(&subjkeyDigest, key, strlen(key));
  MD5Final(subjIDEAkey, &subjkeyDigest);

  sprintf(tempfile, "%sS", origfile);
  rename(origfile, tempfile);

  in = fopen(tempfile, "r");
  if (in == NULL) {
    out = fopen(origfile, "w");
    fclose(out);
    return;
  }
  out = fopen(origfile, "w");

  while (fgets(line, sizeof(line), in)) {
    if (!headers) {
      if ((linenum > colhead) || (strlen(line) > 1))
	linenum++;
      if ((linenum == 1) && (strstr(line, "::") != NULL)) {
	headers = 1;
	colhead = 1;
	fputs(line, out);
      } else if ((linenum == (colhead + 1)) && (strstr(line, "##") != NULL)) {
	addhead = 1;
	fputs(line, out);
      } else {
	if (addhead) {
	  if (strlen(line) <= 1)
	    addhead = 0;
	  strcpy(tmpline, line);
	  stringlower(tmpline);
	  if (strncmp(tmpline, "subject:", 8) != 0) {
	    fputs(line, out);
	  } else {
	    strcpy(tmpline, line + 8);
	    chop(tmpline);
	    MD5Init(&subjectDigest);
	    MD5Update(&subjectDigest, tmpline, strlen(tmpline));
	    MD5Final(subjPT, &subjectDigest);
	    ideaCfbInit(&subjcontext, subjIDEAkey);
	    memcpy(subjCT, genid(), 8);
	    memcpy(subjCT + 8, subjPT, 16) ;
	    ideaCfbEncrypt(&subjcontext, subjCT, subjCT, 24);
	    ideaCfbDestroy(&subjcontext);
	    fprintf(out, "Subject: ");
	    for(x = 0; x < 24; x++) fprintf(out, "%2.2hx", subjCT[x]);
	    fprintf(out, "\n");
	  }
	} else {
          if ((linenum > colhead) || (strlen(line) > 1))
            fputs(line, out);
	}
      }
    } else {
      if (strlen(line) <= 1)
	headers = 0;
      strcpy(tmpline, line);
      stringlower(tmpline);
      if (strncmp(tmpline, "encrypt-subject:", 16) != 0)
	fputs(line, out);
    }
  }
  fclose(in);
  fclose(out);
  unlink(tempfile);
}
