/* article.c
reads an article for your benefit
by eric hollander hh@xcf.berkeley.edu
part of my news-by-mail package
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#include <strings.h>
#include <ctype.h>

#include "lines.h"
#include "nntpcodes.h"

void usage() {
		fprintf(stderr, "usage:\n");
		fprintf(stderr, "article news.group number[-number]\n");
		exit(1);
}

int head(int soc, int n) {
	/* read the head of article n from the socket soc,
	returning 1 if it was sucessful, 0 if failed */

	char buf[BUFSIZ], *line;

	sprintf(buf, "head %d\n", n);
	write(soc, buf, strlen(buf));
	line = getline(soc);
	if(strncmp(line, BAD_ARTICLE_NUM, 3) == 0) {
		fprintf(stderr, "bad article number: %d (continuing)\n", n);
		return 0;
		}
	line = getline(soc);
	while (strcmp(line, ".\n") != 0) {
		printf("%s", line);
		line = getline(soc);
		}
	return 1;
}


int body(int soc) {
	/* get the body of the current article */

	char *line;

	write(soc, "body\n", 5);
	line = getline(soc);
	if(strncmp(line, BODY, 3) != 0) {
		fprintf(stderr, "problem with body of article\n");
		send_quit(soc);
		exit(1);
	}
	line = getline(soc);
	while(strcmp(line, ".\n") != 0) {
		printf("%s", line);
		line = getline(soc);
		}
	return 1;
}

int first_and_last(char *s, int *f, int *l) {
	/* given a string like 55-59 put 55 in &f, etc
	returning 1 if everything is ok */

	int first = 0, last = 0, j = 0, i = 0;
	char buf[BUFSIZ];

	while(isdigit(*(s + i)) && (i < strlen(s))) {
		buf[i] = *(s + i);
		i++;
	}
	if(i == 0) { usage(); }
	buf[i + 1] = NULL;
	first = atoi(buf);
	if(i == strlen(s)) { last = first; }
	else {
		if(*(s + i) != '-') { usage(); }
		else {
			j = 0;
			i++;
			while(isdigit(*(s + i)) && (i < strlen(s))) {
				buf[j] = *(s + i);
				j++; i++;
			}
			if(j == 0) { usage(); }
			buf[j + 1] = NULL;
			last = atoi(buf);
			}
		}
	if(last >= first) {
		*f = first; *l = last;
		return 1;
	}
	else {
		*f = last; *l = first;
		return 1;
	}
}

main(int argc, char *argv[]) {
	int first = 0, last = 0, i = 0, j = 0;
	int soc;	/* the socket */
	char buf[BUFSIZ];
	char *line;

	if(argc != 3) usage();

	first_and_last(argv[2], &first, &last);

	soc = open_soc(nntp_server());

	if ((line = getline(soc)) == 0) {
		fprintf(stderr, "server not responding, you die\n");
		exit(1);
	}

	if(strncmp(line, WELCOME, 3) != 0) {
		fprintf(stderr, "server %s refused connection.\n",
			nntp_server());
		exit(1);
	}

	sprintf(buf, "group %s\n", argv[1]);
	write(soc, buf, strlen(buf));
	line = getline(soc);
	if(strncmp(line, NO_SUCH_GROUP, 3) == 0) {
		fprintf(stderr, "no such newsgroup\n");
		send_quit(soc);
		exit(1);
		}

	i = first;
	do {
		if (head(soc, i)) {
			printf("\n");
			body(soc);
			printf("\n");
		}
		i++;
	} while(i < last);

	send_quit(soc);
}
