/* Mail-to-Usenet
   By Matthew Ghio <M.Ghio@CMU.EDU>
   Version 1
   October 29, 1994 */

/* This program takes a message with mail (RFC822) headers, and reformats
   it to use usenet (RFC977) formatted headers, to allow posting to
   usenet via email.  The output from this program can be sent to a
   program such as inews for NNTP posting.
   
   This program will accept a Newsgroups header in the input mail message
   with a list of groups to post to, and/or newsgroups in the To: or CC:
   lines with the format news.group.name@this.site, and will crosspost
   accordingly.  The headers must be in RFC822 format; local addresses
   without full domains will not work.
   */

#include <stdio.h>

char input[256];
char from[256]="";
char subject[256]="";
char organization[256]="Organization: Mail to Usenet Gateway\n";
char newsgroups[1024]="";
int newsgroupslen=0;

int strbegin(char str1[],char str2[]) {
  int x=0;
  int match=0;
  
  while ((str1[x]==str2[x]||str1[x]==(str2[x]-32))&&str1[x]!=0) {
     x++;
     if (str2[x]==0) match=1;
  }
  return(match);
}

/* Add a group to the newsgroups header if it isn't there already */
int addgroup(char group[]) {
  int x=0;
  int y=0;
  int match=0;

  while(newsgroups[x]!=0) {
    y=0;
    while(((newsgroups[x+y]==group[y])||(newsgroups[x+y]==(group[y]-32)))
           &&((x+y)<newsgroupslen)) {
      y++;
      if ((group[y]==0)&&((newsgroups[x+y]==',')||(newsgroups[x+y]==0))) {
        match=1;
      }
    }
    x++;
  }
  if (!match) {
    if (newsgroupslen>0) {newsgroups[newsgroupslen]=',';newsgroupslen++;}
    y=0;
    while(group[y]>0) {
      newsgroups[newsgroupslen]=group[y];
      newsgroupslen++;y++;
      if (newsgroupslen>1023) newsgroupslen=1023;
      /* Nobody should ever need to cross-post to that many groups! */
    }
    newsgroups[newsgroupslen]=0;
  }
}

/* Search To: and CC: headers for newsgroups */
void getnewsgroups(char header[]) {
  char group[256];
  int x=0;
  int y=0;
  int z=0;
  
  while (header[x]>0) {
    if (header[x]=='@') {
      y=x;
      while (header[y]!='.'&&header[y]!=','&&header[y]>' '&&header[y]!='<') y--;
      /* All newsgroup names must contain at least one dot */
      if (header[y]=='.') {
        while (header[y]!=','&&header[y]>' '&&header[y]!='<') y--;
        y++;z=0;
        while(header[y]!='@'){
          group[z]=header[y];
          z++;y++;
        }
        group[z]=0;
        addgroup(group);
      }
    }
    x++;
  }
}

/* Append the newsgroups in a pre-existing newsgroups header */
void appendnewsgroups(char header[]) {
  int x=0;
  int y=0;
  char group[256];
  
  /* Skip over Newsgroups: part */
  while (header[x]!=':') x++;
  x++;
  while (header[x]>31) {
    if (header[x]==' ') x++;
    else if (header[x]==',') x++;
    else {
      y=0;
      while(header[x]>32&&header[x]!=','){
        group[y]=header[x];
        y++;x++;
      }
      group[y]=0;
      addgroup(group);
    }
  }
}

void eatheader() {
  input[0]=10;input[1]=0;
  fgets(input,255,stdin);
  while (input[0]!=10&&input[0]<=32) {
    input[0]=10;input[1]=0;
    fgets(input,255,stdin);
  }
}

void main(int argc,char *argv[]) {
  fgets(input,255,stdin);
  /* Scan headers */
  while(input[0]!=10) {    
    if (strbegin(input,"received:")) eatheader();
    else if (strbegin(input,"return")) eatheader();
    else if (strbegin(input,"subject:")) {strcpy(subject,input);eatheader();}
    else if (strbegin(input,"from:")) {strcpy(from,input);eatheader();}
    else if (strbegin(input,"from")) eatheader();
    else if (strbegin(input,"date:")) eatheader();
    else if (strbegin(input,"organization:")) {strcpy(organization,input);eatheader();}
    else if (strbegin(input,"newsgroups:")) {appendnewsgroups(input);eatheader();}
    else if (strbegin(input,"to:")||strbegin(input,"cc:")||strbegin(input,"apparently-to:"))
    {
      getnewsgroups(input);
      /* To headers aren't really RFC 977 compliant, so add an X- */
      printf("X-%s",input);
      input[0]=10;input[1]=0;
      fgets(input,255,stdin);
      while (input[0]!=10&&input[0]<=32) {
        getnewsgroups(input);
        printf("%s",input);
        input[0]=10;input[1]=0;
        fgets(input,255,stdin);
      }
    }
    /* Pass thru any additional headers unchanged */
    else if (input[0]>32) {
      printf("%s",input);
      input[0]=10;input[1]=0;
      fgets(input,255,stdin);
      while (input[0]!=10&&input[0]<=32) {
        printf("%s",input);
        input[0]=10;input[1]=0;
        fgets(input,255,stdin);
      }
    }
    else
    {
      input[0]=10;input[1]=0;
      fgets(input,255,stdin);
    }
  }
  printf("Path: mail\n");
  printf("Newsgroups: %s\n",newsgroups);
  printf("%s",organization);
  printf("%s",from);
  printf("%s",subject);  
  printf("\n");
  
  /* Copy the body of the message */
  while (fgets(input,255,stdin)) printf("%s",input);
}
