/*
 * getfrom.c        1.0 4/23/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

/*
 * Modified to use sscanf and check for Reply-To: header; added some comments
 * -Futplex <futplex@pseudonym.com> 95/07/28
 *
 */

#include <stdio.h>
#include "mixmaster.h"

#define NewLineChar 10
#define SpaceChar ' '

/* pass filename, and string to hold address */
void get_from(char *tmpname, char *from)
{
  char input[256];
  char tempstr[256];
  char tempchar;
  char from_address[256] = "";
  int EOF_Reached;
  int i;
  int BestFound = 2;
  FILE *fptr;

  static char *Header[] = {
    "reply-to:%c%s",
    "from:%c%s"
  };

  /* RFC 822 <URL: http://ds.internic.net/rfc/rfc822.txt> recommends
   * that automatic replies be directed to originating address(es)
   * according to the following priority:
   * (0) contents of Reply-To: header, if present
   * (1) contents of From: header, if no Reply-To: header is present
   */

  /* open the file for reading */
  if ((fptr = fopen(tmpname,"r")) == NULL)
    return;

  /* read headers a line at a time */
  while (fgets(input,255,fptr) != NULL) {

    /* newline (ASCII 10) on its own delineates the header/body boundary  */
    if (input[0] == NewLineChar)
      break;

    /* look for an RFC 822 preferred reply header (case insensitive match) */
    SafeToLowerStr(input);
    for (i = 0; i < BestFound; i++) {
      if ((sscanf(input, Header[i], &tempchar, tempstr) == 2) &&
          (tempchar == SpaceChar)) {
        strcpy(from_address, input + strlen(Header[i]) - 3);
        BestFound = i;
        break;
      }
    }

    /* stop looking if we've already found a Reply-To: header */
    if (BestFound == 0)
      break;
  }

  /* close the input file, and return the reply address */
  fclose(fptr);
  strcpy(from, from_address);
}
