/*
 * random.c        1.0 4/23/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include "mixmaster.h"
#include <stdio.h>
#include "crypt.h"

static	R_RANDOM_STRUCT	random_struct;
static	int	initialized=0;

R_RANDOM_STRUCT *rand_struct()
{
	return(&random_struct);
}


void init_our_random()
{
	FILE	*fp,*lockptr;
	byte	privseed[256];


	R_RandomInit(&random_struct);
	initialized = 1;
        /* Setup random number seeding */

        mix_lock("mixrand",&lockptr);
        if (fp = open_mix_file ("mixrand.bin", "rb")) {
                fread (privseed, 256, 1, fp);
                fclose (fp);
        }
        mix_unlock("mixrand",lockptr);
        add_to_random(privseed,256);
	R_memset(privseed,0,256);
}

void close_our_random()
{
	FILE	*fp,*lockptr;
	byte	privseed[256];

	our_randombyte(); /* make sure we can get bytes */
	R_GenerateBytes (privseed, 256, &random_struct);
        mix_lock("mixrand",&lockptr);
        if (fp = open_mix_file ("mixrand.bin", "wb")) {
                fwrite (privseed, 256, 1, fp);
                fclose (fp);
        }
        mix_unlock("mixrand",lockptr);
	R_memset(privseed,0,256);
}

int add_to_random(buff,len)
unsigned char *buff;
int	len;
{
	if(!initialized) return(-1);
	R_RandomUpdate(&random_struct,buff,len);
	return(0);
}

unsigned char our_randombyte()
{
	int	needed,x;
	struct timeval tv;
	unsigned char	foo;

	R_GetRandomBytesNeeded(&needed,&random_struct);
	x = sizeof(tv);
	while(needed > 0) { /* if it thinks it needs more randomness */
	   /* fake it */
	   gettimeofday(&tv,0);
	   R_RandomUpdate(&random_struct,(unsigned char *)&tv,x);
	   R_GetRandomBytesNeeded(&needed,&random_struct);
	}
	R_GenerateBytes (&foo, 1, &random_struct);
	return(foo);
}

void update_random()
{
	struct timeval tv;

	gettimeofday(&tv,0);
	R_RandomUpdate(&random_struct,(unsigned char *)&tv,sizeof(tv));
}
