/* newindex.C - used for access control.

Donated to the public domain by the author (Michael Paul Johnson). No 
warranty, expressed or implied. Use this entirely at your own risk.

*/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#ifndef NO_UNISTD
#include <unistd.h>
#endif
#include <string.h>
#include "def.h"
#include "diamond2.h"

#define MAXLINE 514

/*
The following key MUST be the same in newdir.C and in newindex.C.
To syncronize a mirror site with an access control site, this key,
the times that newdir and newindex is run, and the system clocks
must be synchronized.
*/

byte diamond_key[20] =
    {0xD9, 0x61, 0x2C, 0x51,
     0xE6, 0x4E, 0x63, 0x11,
     0xB7, 0x84, 0x88, 0xB4,
     0xE2, 0xE8, 0xBD, 0xB9,
     0x60, 0x58, 0x75, 0xC3};

byte input_block[8] =
    {0,0,0,0,0, 0x03, 0xD0, 0x7D};

byte output_block[8];

char fchars[] = 
  "23456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ-_.lIO01";

char dirname[10];

void ReplaceString(char *s, char *s1, char *s2)
/* Replaces all occurances of s1 with s2 in the string s. The two strings 
   s1 and s2 must be the same length for this to work properly.
*/
    {
    int i, L;
    char *tmp;

    L = strlen(s1);
    i = strlen(s2);
    if (i < L) L = i;
    if (!strcmp(s1,s2)) return; // We're done. (Avoid infinite loop.)
    do
        {
        tmp = strstr(s, s1);
        if (tmp)
            {
            for (i=0;i<L;i++)
                {
                *tmp++ = s2[i];
                }
            }
        }
    while(tmp);
    }

void UpdateFile(char *DatName)
    {
    char HTMLName[MAXLINE];
    FILE *infile;
    FILE *outfile;
    char line[MAXLINE];
    char *s;
    char *p;
    int i;

    // Extract HTML file name from DatName

    strncpy(HTMLName,DatName,MAXLINE);
    HTMLName[MAXLINE-5] = 0;
    i = strlen(HTMLName) - 4;
    strcpy(HTMLName+i,".htm");

    // printf("%s -> %s\n",DatName,HTMLName);

    // Update the .htm file.

    line[MAXLINE-1] = 0;
    if ((infile = fopen(DatName, "rt")) != NULL)
        {
        if ((outfile = fopen(HTMLName, "w+t")) != NULL)
            {
            do
                {
                s = fgets(line, MAXLINE, infile);
                if (s)
                    {
                    ReplaceString(line,"OOOO0000",dirname);
                    fputs(line, outfile);
                    }
                }
            while (s);
            fclose(outfile);
            fclose(infile);
            }
        else
            {
            printf("Unable to open %s\n",HTMLName);
            }
        }
    else
        {
        printf("Unable to open %s\n",DatName);
        }
    }

int main(int argc, char **argv)
    {
    char s[256];
    int i,j;
    time_t t;
    struct tm *gmt;

    // Initialize plain text block from coordinated universal time.

    t = time(NULL);
    gmt = gmtime(&t);  // Round down to nearest hour
    input_block[0] = gmt->tm_hour;
    input_block[1] = gmt->tm_mday;
    input_block[2] = gmt->tm_mon;
    input_block[4] = gmt->tm_year;

    // Encrypt the block & derive a directory name.

    set_diamond2_key(diamond_key,20,10,false,8); // 10-round Diamond Lite
    lite2_encrypt_block(input_block,output_block);
    diamond2_done();

    for (i = 0; i<8; i++)
        {
        dirname[i] = fchars[output_block[i] % 56];
        }
    dirname[8] = 0;
    // printf("New crypto directory name is %s\n", dirname);

    // Update index files from *.dat -> *.htm

    for (i=1;i<argc;i++)
        UpdateFile(argv[i]);
    return 0;
}
