#include <stdio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include "cgic.h"



#define RAWPAGE    "/home/mpj/index.htm"
#define DENIED     "http://www.cryptography.org/freecryp.htm"
#define SOURCEFORM "http://www.cryptography.org/noexport.htm"

#define MAXURL 300

static FILE *f;
static char s3[6];
static char s2[6];
static char s1[6];
static char domain[6];
static time_t t, expire_time;
static struct tm *mst;
static struct tm *gmt;
static int fAccessOk, fDomainOk, fFormFound, i, j, k;

int cgiMain(void) {							
    /* Verify 3 correct answers. */

    s1[0] = s2[0] = s3[0] = 0;
    fAccessOk = (cgiFormStringNoNewlines("Location", s1, 5) == cgiFormSuccess);
    fAccessOk &= (cgiFormStringNoNewlines("Citizenship", s2, 5) == cgiFormSuccess);
    fAccessOk &= (cgiFormStringNoNewlines("Promise", s3, 5) == cgiFormSuccess);
    fFormFound = fAccessOk;
    fAccessOk &= !strcmp(s1,"Yes");
    fAccessOk &= !strcmp(s2,"Yes");
    fAccessOk &= !strcmp(s3,"Yes");

    /* Verify acceptable domain. */

    fDomainOk = 1; /* Benefit of the doubt (dynamic PPP) goes to the user. */
    if (cgiRemoteHost[0])
        {
        i = j = strlen(cgiRemoteHost) - 1;
        if (i > 2)
            {
            while ((i >= 0) && (cgiRemoteHost[i] != '.'))
                i--;
            i++;
            k = 0;
            while ((i <= j) && (k < 4))
                {
                domain[k++] = tolower(cgiRemoteHost[i++]);
                }
            domain[k] = 0;
            if (isalpha(domain[0]))
                {
                fDomainOk = 0; /* We have a domain: force compliance. */
                if (!strcmp(domain, "com"))
                    fDomainOk = 1;
                else if (!strcmp(domain, "us"))
                    fDomainOk = 1;
                else if (!strcmp(domain, "net"))
                    fDomainOk = 1;
                else if (!strcmp(domain, "org"))
                    fDomainOk = 1;
                else if (!strcmp(domain, "edu"))
                    fDomainOk = 1;
                else if (!strcmp(domain, "gov"))
                    fDomainOk = 1;
                else if (!strcmp(domain, "mil"))
                    fDomainOk = 1;
                else if (!strcmp(domain, "ca")) /* Export to Canada is OK. */
                    fDomainOk = 1;
                }
            }
        }
    fAccessOk &= fDomainOk;

    if (fFormFound)
        {
        if (fAccessOk)
            {
            /* Serve the crypto index. */

            f = fopen(RAWPAGE, "rb");
            if (f)
                {
                fprintf(cgiOut, "Content-type: text/html\r\n\r\n");
                do
                    {
                    i = fgetc(f);
                    if ((i != EOF) && (i != 13))
                        {
			if (i == 10)
			    { // Standardize line ends to CR LF
			    fputc(13,cgiOut); // CR
	    	            fputc(10,cgiOut); // LF
			    }
                        else
                            fputc(i,cgiOut);
                        }
                    }
                while (i != EOF);
                fclose(f);
                }
            else
                {
                // PrintDebugStuff();
                cgiHeaderLocation(SOURCEFORM);
                }
            }
        else
            { // Redirect to crypto links outside of North America.
            cgiHeaderLocation(DENIED);
            }
        }
    else
        { // Not started from form: redirect to the proper form.
        cgiHeaderLocation(SOURCEFORM);
        }
    return 0;
}

